# Dedicated blackjack processing - called only for active players
# Enable triggers
scoreboard players enable @s blackjackHit
scoreboard players enable @s blackjackStand
scoreboard players enable @s blackjackQuit

# ===== PROCESS PLAYER ACTIONS =====
# Handle player hit
execute if score @s blackjackHit matches 1.. if score @s blackjack.game_phase matches 2 run function economy:games/blackjack/player_hit
execute if score @s blackjackHit matches 1.. unless score @s blackjack.game_phase matches 2 run tellraw @s {"text":"It's not your turn to hit!","color":"yellow"}
execute if score @s blackjackHit matches 1.. run scoreboard players set @s blackjackHit 0

# Handle player stand
execute if score @s blackjackStand matches 1.. if score @s blackjack.game_phase matches 2 run function economy:games/blackjack/player_stand
execute if score @s blackjackStand matches 1.. unless score @s blackjack.game_phase matches 2 run tellraw @s {"text":"It's not your turn to stand!","color":"yellow"}
execute if score @s blackjackStand matches 1.. run scoreboard players set @s blackjackStand 0

# Handle quit
execute if score @s blackjackQuit matches 1.. run function economy:games/blackjack/quit_game
execute if score @s blackjackQuit matches 1.. run scoreboard players set @s blackjackQuit 0

# ===== PROCESS BEST OF 3 TOGGLE =====
execute if score @s bestOf3 matches 1.. run tellraw @s {"text":"Cannot change series mode during active game!","color":"red"}
execute if score @s bestOf3 matches 1.. run scoreboard players set @s bestOf3 0

# ===== TURN TIMER SYSTEM =====
# Increment timer for players whose turn it is
execute if score @s blackjack.game_phase matches 2 run scoreboard players add @s blackjack.turn_timer 1
# Check for timeout (120 seconds = 2400 ticks)
execute if score @s blackjack.game_phase matches 2 if score @s blackjack.turn_timer matches 2400.. run function economy:games/blackjack/timeout_loss
# Warning at 60 seconds (1200 ticks)
execute if score @s blackjack.game_phase matches 2 if score @s blackjack.turn_timer matches 1200 run tellraw @s {"text":"⚠ 60 seconds left to make your move!","color":"yellow","bold":true}
# Warning at 15 seconds (2100 ticks)  
execute if score @s blackjack.game_phase matches 2 if score @s blackjack.turn_timer matches 2100 run tellraw @s {"text":"⚠ 15 seconds left!","color":"red","bold":true}
# Reset timer when not player's turn
execute unless score @s blackjack.game_phase matches 2 run scoreboard players set @s blackjack.turn_timer 0

# ===== AUTOMATIC GAME STATE PROCESSING =====
# Handle automatic progression for dealing phase
execute if score @s blackjack.game_phase matches 1 run function economy:games/blackjack/deal_initial_cards

# Handle phase 3 differently for single-player vs multiplayer
# Single player: run computer turn immediately
execute if score @s blackjack.game_phase matches 3 unless score @s blackjack.game_state matches 1 run function economy:games/blackjack/computer_turn

# Multiplayer: check if both players are ready
execute if score @s blackjack.game_phase matches 3 if score @s blackjack.game_state matches 1 run function economy:games/blackjack/check_multiplayer_ready

# Handle game end processing (when game_phase = 4) - ONLY for single player vs computer
execute if score @s blackjack.game_phase matches 4 run function economy:games/blackjack/end_game