# Macro function to find who owns the winning lot
# This looks up the owner of the specific lot number

# Reset winner flag
scoreboard players set #global foundWinner 0

# Check if this lot exists and get owner ID
$execute if score lot$(winning_lot) lotOwner matches 1.. run scoreboard players operation #global winnerID = lot$(winning_lot) lotOwner
$execute if score lot$(winning_lot) lotOwner matches 1.. run scoreboard players set #global foundWinner 1

# Find the player with the matching ID and tag them as winner
execute if score #global foundWinner matches 1 as @a if score @s playerID = #global winnerID run tag @s add raffleWinner
execute if score #global foundWinner matches 1 as @a if score @s playerID = #global winnerID run scoreboard players set @s wasRaffleWinner 1
execute if score #global foundWinner matches 1 as @a if score @s playerID = #global winnerID run scoreboard players set #global lastWinner 1

# Debug message
execute if score #global foundWinner matches 1 run tellraw @a[scores={TreasurerJob=1..}] [{"text":"DEBUG: Winner found - ","color":"green"},{"selector":"@a[tag=raffleWinner]"}]
execute unless score #global foundWinner matches 1 run tellraw @a[scores={TreasurerJob=1..}] [{"text":"DEBUG: No owner found for lot ","color":"red"},{"text":"$(winning_lot)"}]