# Check if lottery price is set, if not use a default
execute unless score #global lottery.price matches 1.. run scoreboard players set #global lottery.price 100

# Calculate 5x the global price
scoreboard players operation @s lottery.bet_amount = #global lottery.price
scoreboard players set @s temp 5
scoreboard players operation @s lottery.bet_amount *= @s temp

# Check if player has enough money
execute if score @s money < @s lottery.bet_amount run tellraw @s [{"text":"Insufficient funds! 5x lottery tickets cost "},{"score":{"name":"@s","objective":"lottery.bet_amount"},"color":"green"},{"text":" money."}]
execute if score @s money < @s lottery.bet_amount run scoreboard players set @s lotteryBetx5 0
execute if score @s money < @s lottery.bet_amount run return 1

# Deduct money
scoreboard players operation @s money -= @s lottery.bet_amount

# Show current jackpot
tellraw @s {"text":"=== LOTTERY TICKETS x5 ===","color":"gold","bold":true}
tellraw @s [{"text":"You bought 5 tickets for "},{"score":{"name":"@s","objective":"lottery.bet_amount"},"color":"green"},{"text":" money!"}]
tellraw @s [{"text":"Current Jackpot: "},{"score":{"name":"#global","objective":"jackpot"},"color":"yellow","bold":true}]
tellraw @s {"text":"Scratching tickets...","color":"aqua"}

# Generate random outcome (1-1000) for each ticket and process
execute store result score @s lottery.outcome run random value 1..1000
function economy:games/lottery/process_outcome

# Reset trigger
scoreboard players set @s lotteryBetx5 0