# ===== FILE: buyer_confirm_sale.mcfunction =====
# Buyer Confirms Sale
# This runs as the buyer attempting to confirm

# Check if player has a pending sale
execute unless score @s pendingSale matches 1 run tellraw @s {"text":"You have no pending chunk sales! A realtor must initiate a sale first.","color":"red"}
execute unless score @s pendingSale matches 1 run return 0

# Check if sale has expired
execute if score @s saleTimer matches ..0 run tellraw @s {"text":"Your chunk sale offer has expired! Please ask the agent to create a new offer.","color":"red"}
execute if score @s saleTimer matches ..0 run function economy:jobs/realtor/clear_pending_sale
execute if score @s saleTimer matches ..0 run return 0

# Re-verify buyer still has enough money
execute if score @s money < @s chunkPrice run tellraw @s {"text":"You no longer have enough money! Sale cancelled.","color":"red"}
execute if score @s money < @s chunkPrice run tellraw @a[scores={Job=4}] [{"text":"Sale cancelled - ","color":"red"},{"selector":"@s"},{"text":" no longer has sufficient funds.","color":"red"}]
execute if score @s money < @s chunkPrice run function economy:jobs/realtor/clear_pending_sale
execute if score @s money < @s chunkPrice run return 0

# Process the sale
function economy:jobs/realtor/process_chunk_sale