# Real Estate System - Core Logic
# This function handles the main real estate operations

# ===== SALE INITIATION =====
# When a realtor uses /trigger sellChunk set 1

# Check if player is a realtor
execute as @a[scores={Job=4,sellChunk=1..}] at @s run function economy:jobs/realtor/realtor_initiate_sale

# Reset trigger
scoreboard players set @a[scores={sellChunk=1..}] sellChunk 0

# ===== SALE CONFIRMATION =====
# When a buyer uses /trigger confirmSale set 1

execute as @a[scores={confirmSale=1..}] run function economy:jobs/realtor/buyer_confirm_sale

# Reset trigger
scoreboard players set @a[scores={confirmSale=1..}] confirmSale 0

# ===== SALE CANCELLATION =====
# When anyone uses /trigger cancelSale set 1

execute as @a[scores={cancelSale=1..}] run function economy:jobs/realtor/cancel_pending_sale

# Reset trigger
scoreboard players set @a[scores={cancelSale=1..}] cancelSale 0

# ===== SALE INFO =====
# When anyone uses /trigger saleInfo set 1

execute as @a[scores={saleInfo=1..}] run function economy:jobs/realtor/show_sale_info

# Reset trigger
scoreboard players set @a[scores={saleInfo=1..}] saleInfo 0

# ===== AUTOMATIC CLEANUP =====
# Reduce sale timers every second (20 ticks)
execute store result score #currentTick dummy run time query gametime
execute store result score #tickMod dummy run scoreboard players get #currentTick dummy
scoreboard players operation #tickMod dummy %= #20 dummy

execute if score #tickMod dummy matches 0 run function economy:jobs/realtor/cleanup_expired_sales