# Set Custom Chunk Price (Realtor Only)
# Usage: /trigger setPrice set <amount>

# Check if player is a realtor
execute unless score @s Job matches 4 run tellraw @s {"text":"Only realtors can set chunk prices!","color":"red"}
execute unless score @s Job matches 4 run scoreboard players set @s setPrice 0
execute unless score @s Job matches 4 run return 0

# Check for valid price (minimum $100, maximum $50000)
execute if score @s setPrice matches ..99 run tellraw @s {"text":"Price must be at least $100!","color":"red"}
execute if score @s setPrice matches ..99 run scoreboard players set @s setPrice 0
execute if score @s setPrice matches ..99 run return 0

execute if score @s setPrice matches 50001.. run tellraw @s {"text":"Price cannot exceed $50,000!","color":"red"}
execute if score @s setPrice matches 50001.. run scoreboard players set @s setPrice 0
execute if score @s setPrice matches 50001.. run return 0

# Store the custom price
scoreboard players operation @s chunkPrice = @s setPrice

# Confirm price set
tellraw @s [{"text":"Chunk price set to $","color":"green"},{"score":{"name":"@s","objective":"chunkPrice"},"color":"white"}]
tellraw @s {"text":"Use /trigger sellChunk set 1 near a player to sell at this price.","color":"yellow"}

# Reset trigger
scoreboard players set @s setPrice 0