# Set market volatility level
# Usage: /trigger setVolatility set <1-3>
# 1 = Casual (1/100 chance), 2 = Moderate (1/50 chance), 3 = High (1/20 chance)

# Validate input
execute if score @s setVolatility matches ..0 run tellraw @s {"text":"✗ Volatility must be between 1-3!","color":"red"}
execute if score @s setVolatility matches 4.. run tellraw @s {"text":"✗ Volatility must be between 1-3!","color":"red"}
execute unless score @s setVolatility matches 1..3 run scoreboard players set @s setVolatility 0
execute unless score @s setVolatility matches 1..3 run scoreboard players enable @s setVolatility
execute unless score @s setVolatility matches 1..3 run return 0

# Set the volatility
scoreboard players operation #global marketVolatility = @s setVolatility

# Display appropriate message based on level
execute if score #global marketVolatility matches 1 run tellraw @s {"text":"✓ Market volatility set to CASUAL (1/100 chance per minute)","color":"green"}
execute if score #global marketVolatility matches 2 run tellraw @s {"text":"✓ Market volatility set to MODERATE (1/50 chance per minute)","color":"yellow"}
execute if score #global marketVolatility matches 3 run tellraw @s {"text":"✓ Market volatility set to HIGH (1/20 chance per minute)","color":"red"}

# Notify other treasurers
execute if score #global marketVolatility matches 1 as @a[scores={TreasurerJob=1}] unless entity @s run tellraw @s [{"selector":"@s","color":"yellow"},{"text":" set market volatility to ","color":"yellow"},{"text":"CASUAL","color":"green"}]
execute if score #global marketVolatility matches 2 as @a[scores={TreasurerJob=1}] unless entity @s run tellraw @s [{"selector":"@s","color":"yellow"},{"text":" set market volatility to ","color":"yellow"},{"text":"MODERATE","color":"yellow"}]
execute if score #global marketVolatility matches 3 as @a[scores={TreasurerJob=1}] unless entity @s run tellraw @s [{"selector":"@s","color":"yellow"},{"text":" set market volatility to ","color":"yellow"},{"text":"HIGH","color":"red"}]

# Reset trigger
scoreboard players set @s setVolatility 0
scoreboard players enable @s setVolatility