# Quick raffle test setup
tellraw @s {"text":"Setting up test raffle...","color":"yellow"}

# Initialize lot system if not already done
execute unless score #global nextLotID matches 1.. run function economy:events/raffle/setup_lot_system

# Set raffle parameters
scoreboard players set #global raffleTicketPrice 1
scoreboard players set #global raffleMaxTickets 1
scoreboard players set #global queuedDuration 1

# Set $1 prize (escrow from city bank) - only if bank has funds
execute if score #cityBank cityBank matches 1.. run scoreboard players remove #cityBank cityBank 1
execute if score #cityBank cityBank matches 0.. run scoreboard players set #global raffleMoney 100
execute unless score #cityBank cityBank matches 1.. run tellraw @s {"text":"City bank needs at least $1 for test","color":"red"}

# Clear other prize types
scoreboard players set #global raffleDiamonds 0
scoreboard players set #global raffleEmeralds 0
scoreboard players set #global raffleCustom 0

# Start the raffle event (only if we have funds)
execute if score #global raffleMoney matches 1.. run scoreboard players set #global eventQueued 1
execute if score #global raffleMoney matches 1.. run scoreboard players set #global queuedEventJob 13
execute if score #global raffleMoney matches 1.. run scoreboard players set #global eventActive 0

# Activate the raffle immediately (only if we have funds)
execute if score #global raffleMoney matches 1.. run function economy:events/start_queued_event

# Set time to just before sunset (12150) (only if raffle started)
execute if score #global raffleMoney matches 1.. run time set 12150

execute if score #global raffleMoney matches 1.. run tellraw @s {"text":"Test raffle active! Max 1 lot per player at $1 each. Time set to 12150.","color":"green"}
execute if score #global raffleMoney matches 1.. run tellraw @s {"text":"Players can now use: /trigger buyRaffleTickets set 1","color":"green"}
execute if score #global raffleMoney matches 1.. run tellraw @s {"text":"Lot system initialized. Each player gets a unique ID.","color":"yellow"}

trigger buyRaffleTickets set 1