# Player wants to buy blacksmith stock
# Format: /trigger buyBlacksmithStock set <shares>

# Store requested amount
scoreboard players operation @s tradeAmount = @s buyBlacksmithStock

# Calculate total cost (price * shares * 1.05 for commission)
scoreboard players operation @s tradeCost = #blacksmithStock blacksmithStockPrice
scoreboard players operation @s tradeCost *= @s tradeAmount
scoreboard players operation @s commission = @s tradeCost
scoreboard players set @s stockTemp 20
scoreboard players operation @s commission /= @s stockTemp
scoreboard players operation @s tradeCost += @s commission

# Enhanced insufficient funds message with details
execute unless score @s money >= @s tradeCost run tellraw @s [{"text":"✗ Insufficient funds!","color":"red"}]
execute unless score @s money >= @s tradeCost run tellraw @s [{"text":"Stock Price: $","color":"yellow"},{"score":{"name":"#blacksmithStock","objective":"blacksmithStockPrice"},"color":"white"},{"text":" per share","color":"yellow"}]
execute unless score @s money >= @s tradeCost run tellraw @s [{"text":"Cost for ","color":"yellow"},{"score":{"name":"@s","objective":"tradeAmount"},"color":"white"},{"text":" shares: $","color":"yellow"},{"score":{"name":"@s","objective":"tradeCost"},"color":"white"}]
execute unless score @s money >= @s tradeCost run tellraw @s [{"text":"Your balance: $","color":"yellow"},{"score":{"name":"@s","objective":"money"},"color":"white"}]
execute unless score @s money >= @s tradeCost run scoreboard players operation @s shareValue = @s tradeCost
execute unless score @s money >= @s tradeCost run scoreboard players operation @s shareValue -= @s money
execute unless score @s money >= @s tradeCost run tellraw @s [{"text":"You need $","color":"red"},{"score":{"name":"@s","objective":"shareValue"},"color":"white"},{"text":" more!","color":"red"}]

# If player has enough money, complete the transaction
execute if score @s money >= @s tradeCost run function economy:stock_market/transaction/blacksmith_transaction

# Reset trigger
scoreboard players set @s buyBlacksmithStock 0
scoreboard players enable @s buyBlacksmithStock