# Apply moderate event change to Hunter stock based on price brackets

# Store old price for comparison
scoreboard players operation #oldPrice dummy = #hunterStock hunterStockPrice

# Generate random number 1-10 for positive/negative determination
execute store result score #direction dummy run random value 1..10

# Price bracket: 0-99 (80% positive 5%, 20% negative 1%)
execute if score #hunterStock hunterStockPrice matches ..99 if score #direction dummy matches 1..8 run function economy:stock_market/events/changes/positive_5
execute if score #hunterStock hunterStockPrice matches ..99 if score #direction dummy matches 9..10 run function economy:stock_market/events/changes/negative_1

# Price bracket: 100-199 (60% negative 10%, 40% positive 3%)
execute if score #hunterStock hunterStockPrice matches 100..199 if score #direction dummy matches 1..6 run function economy:stock_market/events/changes/negative_10
execute if score #hunterStock hunterStockPrice matches 100..199 if score #direction dummy matches 7..10 run function economy:stock_market/events/changes/positive_3

# Price bracket: 200-299 (70% negative 20%, 30% positive 3%)
execute if score #hunterStock hunterStockPrice matches 200..299 if score #direction dummy matches 1..7 run function economy:stock_market/events/changes/negative_20
execute if score #hunterStock hunterStockPrice matches 200..299 if score #direction dummy matches 8..10 run function economy:stock_market/events/changes/positive_3

# Price bracket: 300-399 (80% negative 30%, 20% positive 3%)
execute if score #hunterStock hunterStockPrice matches 300..399 if score #direction dummy matches 1..8 run function economy:stock_market/events/changes/negative_30
execute if score #hunterStock hunterStockPrice matches 300..399 if score #direction dummy matches 9..10 run function economy:stock_market/events/changes/positive_3

# Price bracket: 400-499 (90% negative 40%, 10% positive 3%)
execute if score #hunterStock hunterStockPrice matches 400..499 if score #direction dummy matches 1..9 run function economy:stock_market/events/changes/negative_40
execute if score #hunterStock hunterStockPrice matches 400..499 if score #direction dummy matches 10 run function economy:stock_market/events/changes/positive_3

# Price bracket: 500+ (100% negative 50%)
execute if score #hunterStock hunterStockPrice matches 500.. run function economy:stock_market/events/changes/negative_50

# Apply the calculated change to the actual price
scoreboard players operation #hunterStock hunterStockPrice += #priceChange dummy

# Enforce min/max limits
execute if score #hunterStock hunterStockPrice < #global stockMinPrice run scoreboard players operation #hunterStock hunterStockPrice = #global stockMinPrice
execute if score #hunterStock hunterStockPrice > #global stockMaxPrice run scoreboard players operation #hunterStock hunterStockPrice = #global stockMaxPrice

# Announce the change
execute if score #hunterStock hunterStockPrice > #oldPrice dummy run tellraw @a [{"text":"  Hunter: $","color":"red"},{"score":{"name":"#oldPrice","objective":"dummy"},"color":"gray"},{"text":" → $","color":"white"},{"score":{"name":"#hunterStock","objective":"hunterStockPrice"},"color":"green"},{"text":" ▲","color":"green","bold":true}]
execute if score #hunterStock hunterStockPrice < #oldPrice dummy run tellraw @a [{"text":"  Hunter: $","color":"red"},{"score":{"name":"#oldPrice","objective":"dummy"},"color":"gray"},{"text":" → $","color":"white"},{"score":{"name":"#hunterStock","objective":"hunterStockPrice"},"color":"red"},{"text":" ▼","color":"red","bold":true}]