# Apply moderate event change to Warrior stock based on price brackets

# Store old price for comparison
scoreboard players operation #oldPrice dummy = #warriorStock warriorStockPrice

# Generate random number 1-10 for positive/negative determination
execute store result score #direction dummy run random value 1..10

# Price bracket: 0-99 (80% positive 5%, 20% negative 1%)
execute if score #warriorStock warriorStockPrice matches ..99 if score #direction dummy matches 1..8 run function economy:stock_market/events/changes/positive_5
execute if score #warriorStock warriorStockPrice matches ..99 if score #direction dummy matches 9..10 run function economy:stock_market/events/changes/negative_1

# Price bracket: 100-199 (60% negative 10%, 40% positive 3%)
execute if score #warriorStock warriorStockPrice matches 100..199 if score #direction dummy matches 1..6 run function economy:stock_market/events/changes/negative_10
execute if score #warriorStock warriorStockPrice matches 100..199 if score #direction dummy matches 7..10 run function economy:stock_market/events/changes/positive_3

# Price bracket: 200-299 (70% negative 20%, 30% positive 3%)
execute if score #warriorStock warriorStockPrice matches 200..299 if score #direction dummy matches 1..7 run function economy:stock_market/events/changes/negative_20
execute if score #warriorStock warriorStockPrice matches 200..299 if score #direction dummy matches 8..10 run function economy:stock_market/events/changes/positive_3

# Price bracket: 300-399 (80% negative 30%, 20% positive 3%)
execute if score #warriorStock warriorStockPrice matches 300..399 if score #direction dummy matches 1..8 run function economy:stock_market/events/changes/negative_30
execute if score #warriorStock warriorStockPrice matches 300..399 if score #direction dummy matches 9..10 run function economy:stock_market/events/changes/positive_3

# Price bracket: 400-499 (90% negative 40%, 10% positive 3%)
execute if score #warriorStock warriorStockPrice matches 400..499 if score #direction dummy matches 1..9 run function economy:stock_market/events/changes/negative_40
execute if score #warriorStock warriorStockPrice matches 400..499 if score #direction dummy matches 10 run function economy:stock_market/events/changes/positive_3

# Price bracket: 500+ (100% negative 50%)
execute if score #warriorStock warriorStockPrice matches 500.. run function economy:stock_market/events/changes/negative_50

# Apply the calculated change to the actual price
scoreboard players operation #warriorStock warriorStockPrice += #priceChange dummy

# Enforce min/max limits
execute if score #warriorStock warriorStockPrice < #global stockMinPrice run scoreboard players operation #warriorStock warriorStockPrice = #global stockMinPrice
execute if score #warriorStock warriorStockPrice > #global stockMaxPrice run scoreboard players operation #warriorStock warriorStockPrice = #global stockMaxPrice

# Announce the change
execute if score #warriorStock warriorStockPrice > #oldPrice dummy run tellraw @a [{"text":"  Warrior: $","color":"dark_red"},{"score":{"name":"#oldPrice","objective":"dummy"},"color":"gray"},{"text":" → $","color":"white"},{"score":{"name":"#warriorStock","objective":"warriorStockPrice"},"color":"green"},{"text":" ▲","color":"green","bold":true}]
execute if score #warriorStock warriorStockPrice < #oldPrice dummy run tellraw @a [{"text":"  Warrior: $","color":"dark_red"},{"score":{"name":"#oldPrice","objective":"dummy"},"color":"gray"},{"text":" → $","color":"white"},{"score":{"name":"#warriorStock","objective":"warriorStockPrice"},"color":"red"},{"text":" ▼","color":"red","bold":true}]