# Set Custom Chunk Price (Realtor Only)
# Usage: /trigger setPrice set <amount>

# Check if player is a realtor
execute unless score @s realtorJob matches 1 run tellraw @s {"text":"Only realtors can set chunk prices!","color":"red"}
execute unless score @s realtorJob matches 1 run scoreboard players set @s setPrice 0
execute unless score @s realtorJob matches 1 run return 0

# Initialize minimum price if not set
execute unless score #global minChunkPrice matches 0.. run scoreboard players set #global minChunkPrice 99

# Check for valid price (minimum set by treasurer, maximum $50000)
execute if score @s setPrice < #global minChunkPrice run tellraw @s [{"text":"Price must be at least $","color":"red"},{"score":{"name":"#global","objective":"minChunkPrice"},"color":"white"},{"text":"!","color":"red"}]
execute if score @s setPrice < #global minChunkPrice run tellraw @s [{"text":"(Minimum set by treasurer: $","color":"gray"},{"score":{"name":"#global","objective":"minChunkPrice"},"color":"white"},{"text":")","color":"gray"}]
execute if score @s setPrice < #global minChunkPrice run scoreboard players set @s setPrice 0
execute if score @s setPrice < #global minChunkPrice run return 0

execute if score @s setPrice matches 500001.. run tellraw @s {"text":"Price cannot exceed $500,000!","color":"red"}
execute if score @s setPrice matches 500001.. run scoreboard players set @s setPrice 0
execute if score @s setPrice matches 500001.. run return 0

# Store the custom price
scoreboard players operation @s chunkPrice = @s setPrice

# Confirm price set
tellraw @s [{"text":"Chunk price set to $","color":"green"},{"score":{"name":"@s","objective":"chunkPrice"},"color":"white"}]
tellraw @s {"text":"Use /trigger sellChunk set 1 near a player to sell at this price.","color":"yellow"}

# Reset trigger
scoreboard players set @s setPrice 0