# Set daily dividend rate
# Usage: /trigger setDividendRate set <value>
# 1 = 0.01%, 2 = 0.02%, 5 = 0.05%, 10 = 0.10%, etc.

# Validate input (must be at least 0, max 100 for 1%)
execute if score @s setDividendRate matches ..-1 run tellraw @s {"text":"✗ Dividend rate must be 0 or higher!","color":"red"}
execute if score @s setDividendRate matches 101.. run tellraw @s {"text":"✗ Dividend rate cannot exceed 100 (1%)!","color":"red"}
execute unless score @s setDividendRate matches 0..100 run scoreboard players set @s setDividendRate 0
execute unless score @s setDividendRate matches 0..100 run scoreboard players enable @s setDividendRate
execute unless score @s setDividendRate matches 0..100 run return 0

# Set the new rate
scoreboard players operation #global dividendRate = @s setDividendRate

# Display appropriate message based on rate
execute if score #global dividendRate matches 0 run tellraw @s {"text":"✓ Daily dividends DISABLED","color":"red"}
execute if score #global dividendRate matches 1 run tellraw @s {"text":"✓ Daily dividend rate set to 0.01%","color":"green"}
execute if score #global dividendRate matches 2 run tellraw @s {"text":"✓ Daily dividend rate set to 0.02%","color":"green"}
execute if score #global dividendRate matches 5 run tellraw @s {"text":"✓ Daily dividend rate set to 0.05%","color":"green"}
execute if score #global dividendRate matches 10 run tellraw @s {"text":"✓ Daily dividend rate set to 0.10%","color":"green"}
execute if score #global dividendRate matches 1..100 unless score @s setDividendRate matches 0 unless score @s setDividendRate matches 1 unless score @s setDividendRate matches 2 unless score @s setDividendRate matches 5 unless score @s setDividendRate matches 10 run tellraw @s [{"text":"✓ Daily dividend rate set to 0.","color":"green"},{"score":{"name":"#global","objective":"dividendRate"},"color":"green"},{"text":"%","color":"green"}]

# Notify other treasurers
execute if score #global dividendRate matches 0 as @a[scores={TreasurerJob=1}] unless entity @s run tellraw @s [{"selector":"@s","color":"yellow"},{"text":" DISABLED daily dividends","color":"red"}]
execute if score #global dividendRate matches 1.. as @a[scores={TreasurerJob=1}] unless entity @s run tellraw @s [{"selector":"@s","color":"yellow"},{"text":" set daily dividend rate to 0.","color":"yellow"},{"score":{"name":"#global","objective":"dividendRate"},"color":"yellow"},{"text":"%","color":"yellow"}]

# Reset trigger
scoreboard players set @s setDividendRate 0
scoreboard players enable @s setDividendRate