# Set Minimum Chunk Price (Treasurer Only)
# Usage: /trigger setMinChunkPrice set <amount>

# Check if player is a treasurer
execute unless score @s TreasurerJob matches 1 run tellraw @s {"text":"Only treasurers can set the minimum chunk price!","color":"red"}
execute unless score @s TreasurerJob matches 1 run scoreboard players set @s setMinChunkPrice 0
execute unless score @s TreasurerJob matches 1 run return 0

# Check for valid minimum (must be at least $1, max $10000)
execute if score @s setMinChunkPrice matches ..0 run tellraw @s {"text":"Minimum price must be at least $1!","color":"red"}
execute if score @s setMinChunkPrice matches ..0 run scoreboard players set @s setMinChunkPrice 0
execute if score @s setMinChunkPrice matches ..0 run return 0

execute if score @s setMinChunkPrice matches 100001.. run tellraw @s {"text":"Minimum price cannot exceed $100,000!","color":"red"}
execute if score @s setMinChunkPrice matches 100001.. run scoreboard players set @s setMinChunkPrice 0
execute if score @s setMinChunkPrice matches 100001.. run return 0

# Store the old minimum for comparison
scoreboard players operation #oldMin dummy = #global minChunkPrice

# Set the new minimum
scoreboard players operation #global minChunkPrice = @s setMinChunkPrice

# Announce to server
tellraw @a {"text":"","color":"white"}
tellraw @a {"text":"=== CHUNK PRICE UPDATE ===","color":"gold","bold":true}
tellraw @a [{"text":"The treasurer has set the minimum chunk price to $","color":"yellow"},{"score":{"name":"#global","objective":"minChunkPrice"},"color":"white"}]
tellraw @a [{"text":"Previous minimum: $","color":"gray"},{"score":{"name":"#oldMin","objective":"dummy"},"color":"white"}]
tellraw @a {"text":"","color":"white"}

# Confirm to treasurer
tellraw @s [{"text":"✓ Minimum chunk price set to $","color":"green"},{"score":{"name":"#global","objective":"minChunkPrice"},"color":"white"}]

# Reset trigger
scoreboard players set @s setMinChunkPrice 0