# Apply major event change to Lumber stock based on price brackets

# Store old price for comparison
scoreboard players operation #oldPrice dummy = #lumberStock lumberStockPrice

# Generate random number 1-10 for positive/negative determination
execute store result score #direction dummy run random value 1..10

# Price bracket: 0-99 (80% positive 5%, 20% negative 1%)
execute if score #lumberStock lumberStockPrice matches ..99 if score #direction dummy matches 1..8 run function economy:stock_market/events/changes/positive_5
execute if score #lumberStock lumberStockPrice matches ..99 if score #direction dummy matches 9..10 run function economy:stock_market/events/changes/negative_1

# Price bracket: 100-199 (60% negative 15%, 40% positive 5%)
execute if score #lumberStock lumberStockPrice matches 100..199 if score #direction dummy matches 1..6 run function economy:stock_market/events/changes/negative_15
execute if score #lumberStock lumberStockPrice matches 100..199 if score #direction dummy matches 7..10 run function economy:stock_market/events/changes/positive_5

# Price bracket: 200-299 (70% negative 30%, 30% positive 5%)
execute if score #lumberStock lumberStockPrice matches 200..299 if score #direction dummy matches 1..7 run function economy:stock_market/events/changes/negative_30
execute if score #lumberStock lumberStockPrice matches 200..299 if score #direction dummy matches 8..10 run function economy:stock_market/events/changes/positive_5

# Price bracket: 300-399 (80% negative 45%, 20% positive 5%)
execute if score #lumberStock lumberStockPrice matches 300..399 if score #direction dummy matches 1..8 run function economy:stock_market/events/changes/negative_45
execute if score #lumberStock lumberStockPrice matches 300..399 if score #direction dummy matches 9..10 run function economy:stock_market/events/changes/positive_5

# Price bracket: 400-499 (90% negative 50%, 10% positive 5%)
execute if score #lumberStock lumberStockPrice matches 400..499 if score #direction dummy matches 1..9 run function economy:stock_market/events/changes/negative_50
execute if score #lumberStock lumberStockPrice matches 400..499 if score #direction dummy matches 10 run function economy:stock_market/events/changes/positive_5

# Price bracket: 500+ (100% negative 60%)
execute if score #lumberStock lumberStockPrice matches 500.. run function economy:stock_market/events/changes/negative_60

# Apply the calculated change to the actual price
scoreboard players operation #lumberStock lumberStockPrice += #priceChange dummy

# Enforce min/max limits
execute if score #lumberStock lumberStockPrice < #global stockMinPrice run scoreboard players operation #lumberStock lumberStockPrice = #global stockMinPrice
execute if score #lumberStock lumberStockPrice > #global stockMaxPrice run scoreboard players operation #lumberStock lumberStockPrice = #global stockMaxPrice

# Announce the change
execute if score #lumberStock lumberStockPrice > #oldPrice dummy run tellraw @a [{"text":"  Lumber: $","color":"dark_green"},{"score":{"name":"#oldPrice","objective":"dummy"},"color":"gray"},{"text":" → $","color":"white"},{"score":{"name":"#lumberStock","objective":"lumberStockPrice"},"color":"green"},{"text":" ▲","color":"green","bold":true}]
execute if score #lumberStock lumberStockPrice < #oldPrice dummy run tellraw @a [{"text":"  Lumber: $","color":"dark_green"},{"score":{"name":"#oldPrice","objective":"dummy"},"color":"gray"},{"text":" → $","color":"white"},{"score":{"name":"#lumberStock","objective":"lumberStockPrice"},"color":"red"},{"text":" ▼","color":"red","bold":true}]