# Accept the blackjack challenge
execute unless score @s blackjack.challenger matches 1.. run tellraw @s {"text":"No active challenge to accept!","color":"red"}
execute unless score @s blackjack.challenger matches 1.. run scoreboard players set @s blackjackAccept 0
execute unless score @s blackjack.challenger matches 1.. run return 1

# Start multiplayer game
scoreboard players operation @s blackjack.game_id = #global blackjack.next_game_id
execute as @a if score @s dummy = @p blackjack.challenger run scoreboard players operation @s blackjack.game_id = #global blackjack.next_game_id
execute as @a if score @s dummy = @p blackjack.challenger run scoreboard players operation @s blackjack.bet_amount = @s blackjackChallenge
scoreboard players operation @s blackjack.bet_amount = @a[limit=1] blackjackChallenge

# Deduct money from both players
execute as @a if score @s dummy = @p blackjack.challenger run scoreboard players operation @s money -= @s blackjack.bet_amount
scoreboard players operation @s money -= @s blackjack.bet_amount

# Calculate total pot
scoreboard players operation @s blackjack.escrow = @s blackjack.bet_amount
scoreboard players operation @s blackjack.escrow *= #2 dummy
execute as @a if score @s dummy = @p blackjack.challenger run scoreboard players operation @s blackjack.escrow = @p blackjack.escrow

# Set game state
scoreboard players set @s blackjack.game_state 1
execute as @a if score @s dummy = @p blackjack.challenger run scoreboard players set @s blackjack.game_state 1
scoreboard players set @s blackjack.total_players 2
execute as @a if score @s dummy = @p blackjack.challenger run scoreboard players set @s blackjack.total_players 2

# Start both games
function economy:games/blackjack/start_multiplayer_game
execute as @a if score @s dummy = @p blackjack.challenger run function economy:games/blackjack/start_multiplayer_game

# Increment game ID for next game
scoreboard players add #global blackjack.next_game_id 1

# Reset challenge data
scoreboard players set @s blackjack.challenger 0
scoreboard players set @s blackjackAccept 0

tellraw @a[scores={blackjack.game_state=1}] {"text":"Multiplayer blackjack game started! Play independently until you both stand or bust.","color":"green"}