# Draw a card for the player
function economy:games/blackjack/draw_card

# Assign to next available slot
execute unless score @s blackjack.p_card4 matches 0 if score @s blackjack.p_card5 matches 0 run scoreboard players operation @s blackjack.p_card5 = @s blackjack.temp
execute unless score @s blackjack.p_card3 matches 0 if score @s blackjack.p_card4 matches 0 run scoreboard players operation @s blackjack.p_card4 = @s blackjack.temp
execute if score @s blackjack.p_card3 matches 0 run scoreboard players operation @s blackjack.p_card3 = @s blackjack.temp

# Add to player total
scoreboard players operation @s blackjack.player_total += @s blackjack.card_value

# Track aces if the card drawn was an ace
execute if score @s blackjack.card_value matches 11 run scoreboard players add @s blackjack.player_aces 1

# Optimize aces
function economy:games/blackjack/optimize_aces_player

# Show the updated hand to the player
function economy:games/blackjack/show_player_hand

# Check for bust
execute if score @s blackjack.player_total matches 22.. run tellraw @s {"text":"BUST! You went over 21!","color":"red","bold":true}
execute if score @s blackjack.player_total matches 22.. run scoreboard players set @s blackjack.game_phase 3

# Check for 21 (move to computer turn)
execute if score @s blackjack.player_total matches 21 run tellraw @s {"text":"You have 21! Standing automatically.","color":"gold"}
execute if score @s blackjack.player_total matches 21 run scoreboard players set @s blackjack.game_phase 3

# If still under 21, allow another hit
execute if score @s blackjack.player_total matches ..20 run tellraw @s {"text":"Your turn! Use /trigger blackjackHit to draw another card or /trigger blackjackStand to keep your hand.","color":"green"}