# Pay Workers (Combined payment with individual job level bonuses)
# Calculates separate payments for farming, mining, and ranching based on individual levels

# Save money before payment for PayDiff calculation
execute as @a[scores={Job=1}] run scoreboard players operation @s moneyBefore = @s money

# Initialize payment calculations
execute as @a[scores={Job=1}] run scoreboard players set @s dummy 0

# FARMER PAYMENT (with multiplier)
execute as @a[scores={Job=1,FarmerLevel=1,WheatHarvested=1..}] run scoreboard players set @s totalFarmer 1
execute as @a[scores={Job=1,FarmerLevel=2,WheatHarvested=1..}] run scoreboard players set @s totalFarmer 2
execute as @a[scores={Job=1,FarmerLevel=3,WheatHarvested=1..}] run scoreboard players set @s totalFarmer 3
execute as @a[scores={Job=1,FarmerLevel=4,WheatHarvested=1..}] run scoreboard players set @s totalFarmer 4
execute as @a[scores={Job=1,FarmerLevel=5,WheatHarvested=1..}] run scoreboard players set @s totalFarmer 5
execute as @a[scores={Job=1,FarmerLevel=6,WheatHarvested=1..}] run scoreboard players set @s totalFarmer 6
execute as @a[scores={Job=1,FarmerLevel=7,WheatHarvested=1..}] run scoreboard players set @s totalFarmer 7
execute as @a[scores={Job=1,FarmerLevel=8,WheatHarvested=1..}] run scoreboard players set @s totalFarmer 8
execute as @a[scores={Job=1,FarmerLevel=9,WheatHarvested=1..}] run scoreboard players set @s totalFarmer 9
execute as @a[scores={Job=1,FarmerLevel=10,WheatHarvested=1..}] run scoreboard players set @s totalFarmer 10
# Apply multiplier to farming payment
execute as @a[scores={Job=1,WheatHarvested=1..}] run scoreboard players operation @s totalFarmer *= @s WheatHarvested
execute as @a[scores={Job=1,WheatHarvested=1..}] run scoreboard players operation @s totalFarmer *= #global farmerMult
execute as @a[scores={Job=1,WheatHarvested=1..}] run scoreboard players set @s multiplier 100
execute as @a[scores={Job=1,WheatHarvested=1..}] run scoreboard players operation @s totalFarmer /= @s multiplier
execute as @a[scores={Job=1,WheatHarvested=1..}] run scoreboard players operation @s dummy += @s totalFarmer
# Divide mining values by 10 before payment calculations
execute as @a[scores={Job=1,MinerXP=1..}] run scoreboard players operation @s MinerXP /= #10 dummy
execute as @a[scores={Job=1,ores_mined=1..}] run scoreboard players operation @s ores_mined /= #10 dummy
# MINER PAYMENT (with multiplier)
execute as @a[scores={Job=1,MinerLevel=1,ores_mined=1..}] run scoreboard players set @s totalMiner 3
execute as @a[scores={Job=1,MinerLevel=2,ores_mined=1..}] run scoreboard players set @s totalMiner 4
execute as @a[scores={Job=1,MinerLevel=3,ores_mined=1..}] run scoreboard players set @s totalMiner 5
execute as @a[scores={Job=1,MinerLevel=4,ores_mined=1..}] run scoreboard players set @s totalMiner 6
execute as @a[scores={Job=1,MinerLevel=5,ores_mined=1..}] run scoreboard players set @s totalMiner 7
execute as @a[scores={Job=1,MinerLevel=6,ores_mined=1..}] run scoreboard players set @s totalMiner 8
execute as @a[scores={Job=1,MinerLevel=7,ores_mined=1..}] run scoreboard players set @s totalMiner 9
execute as @a[scores={Job=1,MinerLevel=8,ores_mined=1..}] run scoreboard players set @s totalMiner 10
execute as @a[scores={Job=1,MinerLevel=9,ores_mined=1..}] run scoreboard players set @s totalMiner 11
execute as @a[scores={Job=1,MinerLevel=10,ores_mined=1..}] run scoreboard players set @s totalMiner 12
# Apply multiplier to mining payment
execute as @a[scores={Job=1,ores_mined=1..}] run scoreboard players operation @s totalMiner *= @s ores_mined
execute as @a[scores={Job=1,ores_mined=1..}] run scoreboard players operation @s totalMiner *= #global minerMult
execute as @a[scores={Job=1,ores_mined=1..}] run scoreboard players set @s multiplier 100
execute as @a[scores={Job=1,ores_mined=1..}] run scoreboard players operation @s totalMiner /= @s multiplier
execute as @a[scores={Job=1,ores_mined=1..}] run scoreboard players operation @s dummy += @s totalMiner

# RANCHER PAYMENT (with multiplier)
execute as @a[scores={Job=1,RancherLevel=1,RanchHarvested=1..}] run scoreboard players set @s totalRancher 1
execute as @a[scores={Job=1,RancherLevel=2,RanchHarvested=1..}] run scoreboard players set @s totalRancher 2
execute as @a[scores={Job=1,RancherLevel=3,RanchHarvested=1..}] run scoreboard players set @s totalRancher 3
execute as @a[scores={Job=1,RancherLevel=4,RanchHarvested=1..}] run scoreboard players set @s totalRancher 4
execute as @a[scores={Job=1,RancherLevel=5,RanchHarvested=1..}] run scoreboard players set @s totalRancher 5
execute as @a[scores={Job=1,RancherLevel=6,RanchHarvested=1..}] run scoreboard players set @s totalRancher 6
execute as @a[scores={Job=1,RancherLevel=7,RanchHarvested=1..}] run scoreboard players set @s totalRancher 7
execute as @a[scores={Job=1,RancherLevel=8,RanchHarvested=1..}] run scoreboard players set @s totalRancher 8
execute as @a[scores={Job=1,RancherLevel=9,RanchHarvested=1..}] run scoreboard players set @s totalRancher 9
execute as @a[scores={Job=1,RancherLevel=10,RanchHarvested=1..}] run scoreboard players set @s totalRancher 10
# Apply multiplier to rancher payment
execute as @a[scores={Job=1,RanchHarvested=1..}] run scoreboard players operation @s totalRancher *= @s RanchHarvested
execute as @a[scores={Job=1,RanchHarvested=1..}] run scoreboard players operation @s totalRancher *= #global hunterMult
execute as @a[scores={Job=1,RanchHarvested=1..}] run scoreboard players set @s multiplier 100
execute as @a[scores={Job=1,RanchHarvested=1..}] run scoreboard players operation @s totalRancher /= @s multiplier
execute as @a[scores={Job=1,RanchHarvested=1..}] run scoreboard players operation @s dummy += @s totalRancher

# BLACKSMITH PAYMENT (with multiplier)
execute as @a[scores={Job=1,BlacksmithLevel=1,BlacksmithCrafted=1..}] run scoreboard players set @s totalBlacksmith 2
execute as @a[scores={Job=1,BlacksmithLevel=2,BlacksmithCrafted=1..}] run scoreboard players set @s totalBlacksmith 3
execute as @a[scores={Job=1,BlacksmithLevel=3,BlacksmithCrafted=1..}] run scoreboard players set @s totalBlacksmith 4
execute as @a[scores={Job=1,BlacksmithLevel=4,BlacksmithCrafted=1..}] run scoreboard players set @s totalBlacksmith 5
execute as @a[scores={Job=1,BlacksmithLevel=5,BlacksmithCrafted=1..}] run scoreboard players set @s totalBlacksmith 6
execute as @a[scores={Job=1,BlacksmithLevel=6,BlacksmithCrafted=1..}] run scoreboard players set @s totalBlacksmith 7
execute as @a[scores={Job=1,BlacksmithLevel=7,BlacksmithCrafted=1..}] run scoreboard players set @s totalBlacksmith 8
execute as @a[scores={Job=1,BlacksmithLevel=8,BlacksmithCrafted=1..}] run scoreboard players set @s totalBlacksmith 9
execute as @a[scores={Job=1,BlacksmithLevel=9,BlacksmithCrafted=1..}] run scoreboard players set @s totalBlacksmith 10
execute as @a[scores={Job=1,BlacksmithLevel=10,BlacksmithCrafted=1..}] run scoreboard players set @s totalBlacksmith 11
# Apply multiplier to blacksmith payment
execute as @a[scores={Job=1,BlacksmithCrafted=1..}] run scoreboard players operation @s totalBlacksmith *= @s BlacksmithCrafted
execute as @a[scores={Job=1,BlacksmithCrafted=1..}] run scoreboard players operation @s totalBlacksmith *= #global blacksmithMult
execute as @a[scores={Job=1,BlacksmithCrafted=1..}] run scoreboard players set @s multiplier 100
execute as @a[scores={Job=1,BlacksmithCrafted=1..}] run scoreboard players operation @s totalBlacksmith /= @s multiplier
execute as @a[scores={Job=1,BlacksmithCrafted=1..}] run scoreboard players operation @s dummy += @s totalBlacksmith

# LUMBER PAYMENT (with multiplier)
execute as @a[scores={Job=1,lumberlevel=1,lumber=1..}] run scoreboard players set @s totalLumber 2
execute as @a[scores={Job=1,lumberlevel=2,lumber=1..}] run scoreboard players set @s totalLumber 3
execute as @a[scores={Job=1,lumberlevel=3,lumber=1..}] run scoreboard players set @s totalLumber 4
execute as @a[scores={Job=1,lumberlevel=4,lumber=1..}] run scoreboard players set @s totalLumber 5
execute as @a[scores={Job=1,lumberlevel=5,lumber=1..}] run scoreboard players set @s totalLumber 6
execute as @a[scores={Job=1,lumberlevel=6,lumber=1..}] run scoreboard players set @s totalLumber 7
execute as @a[scores={Job=1,lumberlevel=7,lumber=1..}] run scoreboard players set @s totalLumber 8
execute as @a[scores={Job=1,lumberlevel=8,lumber=1..}] run scoreboard players set @s totalLumber 9
execute as @a[scores={Job=1,lumberlevel=9,lumber=1..}] run scoreboard players set @s totalLumber 10
execute as @a[scores={Job=1,lumberlevel=10,lumber=1..}] run scoreboard players set @s totalLumber 11
# Apply multiplier to lumber payment
execute as @a[scores={Job=1,lumber=1..}] run scoreboard players operation @s totalLumber *= @s lumber
execute as @a[scores={Job=1,lumber=1..}] run scoreboard players operation @s totalLumber *= #global lumberjackMult
execute as @a[scores={Job=1,lumber=1..}] run scoreboard players set @s multiplier 100
execute as @a[scores={Job=1,lumber=1..}] run scoreboard players operation @s totalLumber /= @s multiplier
execute as @a[scores={Job=1,lumber=1..}] run scoreboard players operation @s dummy += @s totalLumber

# HUNTER PAYMENT (with multiplier)
execute as @a[scores={Job=1,HunterLevel=1,Hunt=1..}] run scoreboard players set @s totalHunter 2
execute as @a[scores={Job=1,HunterLevel=2,Hunt=1..}] run scoreboard players set @s totalHunter 3
execute as @a[scores={Job=1,HunterLevel=3,Hunt=1..}] run scoreboard players set @s totalHunter 4
execute as @a[scores={Job=1,HunterLevel=4,Hunt=1..}] run scoreboard players set @s totalHunter 5
execute as @a[scores={Job=1,HunterLevel=5,Hunt=1..}] run scoreboard players set @s totalHunter 6
execute as @a[scores={Job=1,HunterLevel=6,Hunt=1..}] run scoreboard players set @s totalHunter 7
execute as @a[scores={Job=1,HunterLevel=7,Hunt=1..}] run scoreboard players set @s totalHunter 8
execute as @a[scores={Job=1,HunterLevel=8,Hunt=1..}] run scoreboard players set @s totalHunter 9
execute as @a[scores={Job=1,HunterLevel=9,Hunt=1..}] run scoreboard players set @s totalHunter 10
execute as @a[scores={Job=1,HunterLevel=10,Hunt=1..}] run scoreboard players set @s totalHunter 11
# Apply multiplier to hunter payment
execute as @a[scores={Job=1,Hunt=1..}] run scoreboard players operation @s totalHunter *= @s Hunt
execute as @a[scores={Job=1,Hunt=1..}] run scoreboard players operation @s totalHunter *= #global hunterMult
execute as @a[scores={Job=1,Hunt=1..}] run scoreboard players set @s multiplier 100
execute as @a[scores={Job=1,Hunt=1..}] run scoreboard players operation @s totalHunter /= @s multiplier
execute as @a[scores={Job=1,Hunt=1..}] run scoreboard players operation @s dummy += @s totalHunter

# COOKING PAYMENT (with multiplier and division by 4)
execute as @a[scores={Job=1,cookinglevel=1,cooking=1..}] run scoreboard players set @s totalCook 1
execute as @a[scores={Job=1,cookinglevel=2,cooking=1..}] run scoreboard players set @s totalCook 2
execute as @a[scores={Job=1,cookinglevel=3,cooking=1..}] run scoreboard players set @s totalCook 3
execute as @a[scores={Job=1,cookinglevel=4,cooking=1..}] run scoreboard players set @s totalCook 4
execute as @a[scores={Job=1,cookinglevel=5,cooking=1..}] run scoreboard players set @s totalCook 5
execute as @a[scores={Job=1,cookinglevel=6,cooking=1..}] run scoreboard players set @s totalCook 6
execute as @a[scores={Job=1,cookinglevel=7,cooking=1..}] run scoreboard players set @s totalCook 7
execute as @a[scores={Job=1,cookinglevel=8,cooking=1..}] run scoreboard players set @s totalCook 8
execute as @a[scores={Job=1,cookinglevel=9,cooking=1..}] run scoreboard players set @s totalCook 9
execute as @a[scores={Job=1,cookinglevel=10,cooking=1..}] run scoreboard players set @s totalCook 10
# Apply multiplier to cooking payment
execute as @a[scores={Job=1,cooking=1..}] run scoreboard players operation @s totalCook *= @s cooking
execute as @a[scores={Job=1,cooking=1..}] run scoreboard players operation @s totalCook *= #global cookMult
execute as @a[scores={Job=1,cooking=1..}] run scoreboard players set @s multiplier 100
execute as @a[scores={Job=1,cooking=1..}] run scoreboard players operation @s totalCook /= @s multiplier
execute as @a[scores={Job=1,cooking=1..}] run scoreboard players operation @s dummy += @s totalCook

# FISHING PAYMENT (with multiplier)
execute as @a[scores={Job=1,FishingLevel=1,FishCaught=1..}] run scoreboard players set @s totalFisher 1
execute as @a[scores={Job=1,FishingLevel=2,FishCaught=1..}] run scoreboard players set @s totalFisher 2
execute as @a[scores={Job=1,FishingLevel=3,FishCaught=1..}] run scoreboard players set @s totalFisher 3
execute as @a[scores={Job=1,FishingLevel=4,FishCaught=1..}] run scoreboard players set @s totalFisher 4
execute as @a[scores={Job=1,FishingLevel=5,FishCaught=1..}] run scoreboard players set @s totalFisher 5
execute as @a[scores={Job=1,FishingLevel=6,FishCaught=1..}] run scoreboard players set @s totalFisher 6
execute as @a[scores={Job=1,FishingLevel=7,FishCaught=1..}] run scoreboard players set @s totalFisher 7
execute as @a[scores={Job=1,FishingLevel=8,FishCaught=1..}] run scoreboard players set @s totalFisher 8
execute as @a[scores={Job=1,FishingLevel=9,FishCaught=1..}] run scoreboard players set @s totalFisher 9
execute as @a[scores={Job=1,FishingLevel=10,FishCaught=1..}] run scoreboard players set @s totalFisher 10
# Apply multiplier to fishing payment
execute as @a[scores={Job=1,FishCaught=1..}] run scoreboard players operation @s totalFisher *= @s FishCaught
execute as @a[scores={Job=1,FishCaught=1..}] run scoreboard players operation @s totalFisher *= #global fisherMult
execute as @a[scores={Job=1,FishCaught=1..}] run scoreboard players set @s multiplier 100
execute as @a[scores={Job=1,FishCaught=1..}] run scoreboard players operation @s totalFisher /= @s multiplier
execute as @a[scores={Job=1,FishCaught=1..}] run scoreboard players operation @s dummy += @s totalFisher

# After calculating total payment (in dummy objective), add tax calculation:
# Calculate dynamic tax on payment
execute as @a[scores={Job=1,dummy=1..}] run scoreboard players operation @s banktemp = @s dummy
execute as @a[scores={Job=1,dummy=1..}] run scoreboard players operation @s multiplier = #taxRate taxRate
execute as @a[scores={Job=1,dummy=1..}] run scoreboard players operation @s banktemp *= @s multiplier
execute as @a[scores={Job=1,dummy=1..}] run scoreboard players set @s multiplier 100
execute as @a[scores={Job=1,dummy=1..}] run scoreboard players operation @s banktemp /= @s multiplier

# Multiply tax by 5 before adding to city bank
execute as @a[scores={Job=1,dummy=1..}] run scoreboard players set @s multiplier 5
execute as @a[scores={Job=1,dummy=1..}] run scoreboard players operation @s temp = @s banktemp
execute as @a[scores={Job=1,dummy=1..}] run scoreboard players operation @s temp *= @s multiplier

# Add multiplied tax to city bank
execute as @a[scores={Job=1,dummy=1..}] run scoreboard players operation #cityBank cityBank += @s temp

# Subtract original tax from player payment (not the multiplied amount)
execute as @a[scores={Job=1,dummy=1..}] run scoreboard players operation @s dummy -= @s banktemp

# Apply final payment to player (after tax deduction)
execute as @a[scores={Job=1,dummy=1..}] run scoreboard players operation @s lastPaycheck = @s dummy
execute as @a[scores={Job=1,dummy=1..}] run scoreboard players operation @s money += @s dummy

# Calculate gross pay for display (net + tax)
execute as @a[scores={Job=1,dummy=1..}] run scoreboard players operation @s multiplier = @s dummy
execute as @a[scores={Job=1,dummy=1..}] run scoreboard players operation @s multiplier += @s banktemp

# Set $0 paycheck for workers with no work
execute as @a[scores={Job=1,dummy=0}] run scoreboard players set @s lastPaycheck 0

# Pay treasurers their flat daily rate
execute as @a[scores={TreasurerJob=1..,treasurerlevel=1}] run scoreboard players add @s money 100
execute as @a[scores={TreasurerJob=1..,treasurerlevel=2}] run scoreboard players add @s money 200
execute as @a[scores={TreasurerJob=1..,treasurerlevel=3}] run scoreboard players add @s money 300
execute as @a[scores={TreasurerJob=1..,treasurerlevel=4}] run scoreboard players add @s money 400
execute as @a[scores={TreasurerJob=1..,treasurerlevel=5}] run scoreboard players add @s money 500
execute as @a[scores={TreasurerJob=1..,treasurerlevel=6}] run scoreboard players add @s money 600
execute as @a[scores={TreasurerJob=1..,treasurerlevel=7}] run scoreboard players add @s money 700
execute as @a[scores={TreasurerJob=1..,treasurerlevel=8}] run scoreboard players add @s money 800
execute as @a[scores={TreasurerJob=1..,treasurerlevel=9}] run scoreboard players add @s money 900
execute as @a[scores={TreasurerJob=1..,treasurerlevel=10}] run scoreboard players add @s money 1000

# Give treasurers 1 cityXP per sunset
execute as @a[scores={TreasurerJob=1..}] run scoreboard players add @s cityXP 1

# Add payment breakdown to payment messages
execute as @a[scores={Job=1,dummy=1..}] run tellraw @s [{"text":"=== SUNSET PAYMENT ===","color":"gold","bold":true}]
execute as @a[scores={Job=1,dummy=1..}] run tellraw @s [{"text":"Gross Pay: $","color":"yellow"},{"score":{"name":"@s","objective":"multiplier"},"color":"green"}]
execute as @a[scores={Job=1,dummy=1..}] run tellraw @s [{"text":"Tax Paid: $","color":"red"},{"score":{"name":"@s","objective":"banktemp"},"color":"white"},{"text":" (","color":"gray"},{"score":{"name":"#taxRate","objective":"taxRate"},"color":"white"},{"text":"% to City Bank)","color":"gray"}]
execute as @a[scores={Job=1,dummy=1..}] run tellraw @s [{"text":"Net Pay: $","color":"yellow","bold":true},{"score":{"name":"@s","objective":"dummy"},"color":"green","bold":true}]
# Send detailed payment breakdown
execute as @a[scores={Job=1,WheatHarvested=1..}] run tellraw @s [{"text":"Farm Work: ","color":"green"},{"score":{"name":"@s","objective":"WheatHarvested"},"color":"white"},{"text":" units (Lv","color":"gray"},{"score":{"name":"@s","objective":"FarmerLevel"},"color":"green"},{"text":")","color":"gray"}]
execute as @a[scores={Job=1,ores_mined=1..}] run tellraw @s [{"text":"Mine Work: ","color":"blue"},{"score":{"name":"@s","objective":"ores_mined"},"color":"white"},{"text":" units (Lv","color":"gray"},{"score":{"name":"@s","objective":"MinerLevel"},"color":"blue"},{"text":")","color":"gray"}]
execute as @a[scores={Job=1,RanchHarvested=1..}] run tellraw @s [{"text":"Ranch Work: ","color":"gold"},{"score":{"name":"@s","objective":"RanchHarvested"},"color":"white"},{"text":" units (Lv","color":"gray"},{"score":{"name":"@s","objective":"RancherLevel"},"color":"gold"},{"text":")","color":"gray"}]
execute as @a[scores={Job=1,Hunt=1..}] run tellraw @s [{"text":"Hunt Work: ","color":"red"},{"score":{"name":"@s","objective":"Hunt"},"color":"white"},{"text":" units (Lv","color":"gray"},{"score":{"name":"@s","objective":"HunterLevel"},"color":"red"},{"text":")","color":"gray"}]
execute as @a[scores={Job=1,FishCaught=1..}] run tellraw @s [{"text":"Fish Work: ","color":"aqua"},{"score":{"name":"@s","objective":"FishCaught"},"color":"white"},{"text":" units (Lv","color":"gray"},{"score":{"name":"@s","objective":"FishingLevel"},"color":"aqua"},{"text":")","color":"gray"}]
execute as @a[scores={Job=1,BlacksmithCrafted=1..}] run tellraw @s [{"text":"Blacksmith Work: ","color":"gold"},{"score":{"name":"@s","objective":"BlacksmithCrafted"},"color":"white"},{"text":" items (Lv","color":"gray"},{"score":{"name":"@s","objective":"BlacksmithLevel"},"color":"gold"},{"text":")","color":"gray"}]
execute as @a[scores={Job=1,lumber=1..}] run tellraw @s [{"text":"Lumber Work: ","color":"dark_green"},{"score":{"name":"@s","objective":"lumber"},"color":"white"},{"text":" units (Lv","color":"gray"},{"score":{"name":"@s","objective":"lumberlevel"},"color":"dark_green"},{"text":")","color":"gray"}]
execute as @a[scores={Job=1,cooking=1..}] run tellraw @s [{"text":"Cooking Work: ","color":"light_purple"},{"score":{"name":"@s","objective":"cooking"},"color":"white"},{"text":" units (Lv","color":"gray"},{"score":{"name":"@s","objective":"cookinglevel"},"color":"light_purple"},{"text":")","color":"gray"}]

execute as @a[scores={Job=1,dummy=0}] run tellraw @s {"text":"No work completed today, no pay!","color":"red"}

# Debug message showing XP breakdown
execute as @a[scores={Job=1}] run tellraw @s [{"text":"XP - Farm: ","color":"gray"},{"score":{"name":"@s","objective":"FarmerXP"},"color":"green"},{"text":" | Mine: ","color":"gray"},{"score":{"name":"@s","objective":"MinerXP"},"color":"blue"},{"text":" | Ranch: ","color":"gray"},{"score":{"name":"@s","objective":"RancherXP"},"color":"gold"},{"text":" | Hunt: ","color":"gray"},{"score":{"name":"@s","objective":"HunterXP"},"color":"red"},{"text":" | Fish: ","color":"gray"},{"score":{"name":"@s","objective":"FishingXP"},"color":"aqua"},{"text":" | Smith: ","color":"gray"},{"score":{"name":"@s","objective":"BlacksmithXP"},"color":"gold"},{"text":" | Lumber: ","color":"gray"},{"score":{"name":"@s","objective":"lumberXP"},"color":"dark_green"},{"text":" | Cook: ","color":"gray"},{"score":{"name":"@s","objective":"cookingXP"},"color":"light_purple"}]

# Treasurer payment notification
execute as @a[scores={TreasurerJob=1..}] run tellraw @s [{"text":"=== TREASURER PAYMENT ===","color":"gold","bold":true}]
execute as @a[scores={TreasurerJob=1..}] run tellraw @s [{"text":"Daily Salary: $","color":"yellow"},{"score":{"name":"@s","objective":"treasurerlevel"},"color":"white"},{"text":"00 (Level ","color":"yellow"},{"score":{"name":"@s","objective":"treasurerlevel"},"color":"white"},{"text":")","color":"yellow"}]

# Check promotions for all workers after paying them
execute as @a[scores={Job=1}] run function economy:jobs/general/check_promotion
execute as @a[scores={Job=1}] run function economy:jobs/general/team_promotion

# Reset work counters
scoreboard players set @a[scores={Job=1}] WheatHarvested 0
scoreboard players set @a[scores={Job=1}] ores_mined 0
scoreboard players set @a[scores={Job=1}] RanchHarvested 0
scoreboard players set @a[scores={Job=1}] Hunt 0
scoreboard players set @a[scores={Job=1}] FishCaught 0
scoreboard players set @a[scores={Job=1}] BlacksmithCrafted 0
scoreboard players set @a[scores={Job=1}] lumber 0
scoreboard players set @a[scores={Job=1}] cooking 0

# Reset temporary scores (including all job totals)
scoreboard players set @a[scores={Job=1}] dummy 0
scoreboard players set @a[scores={Job=1}] targetJob 0
scoreboard players set @a[scores={Job=1}] totalFarmer 0
scoreboard players set @a[scores={Job=1}] totalMiner 0
scoreboard players set @a[scores={Job=1}] totalRancher 0
scoreboard players set @a[scores={Job=1}] totalBlacksmith 0
scoreboard players set @a[scores={Job=1}] totalLumber 0
scoreboard players set @a[scores={Job=1}] totalHunter 0
scoreboard players set @a[scores={Job=1}] totalCook 0
scoreboard players set @a[scores={Job=1}] totalFisher 0

# Calculate PayDiff (money gained) after payment
execute as @a[scores={Job=1}] run scoreboard players operation @s PayDiff = @s money
execute as @a[scores={Job=1}] run scoreboard players operation @s PayDiff -= @s moneyBefore

# Set flag to prevent multiple pays
scoreboard players set workerPayFlag workerPayFlag 1
scoreboard players set #startup startupFlag 0