# Challenge nearest player within 5 blocks to blackjack
execute at @s unless entity @p[distance=0.1..5] run tellraw @s {"text":"No players nearby to challenge!","color":"red"}
execute at @s unless entity @p[distance=0.1..5] run scoreboard players set @s blackjackChallenge 0
execute at @s unless entity @p[distance=0.1..5] run return 1

# Check if challenger has enough money
execute if score @s money < @s blackjackChallenge run tellraw @s {"text":"Insufficient funds for that bet!","color":"red"}
execute if score @s money < @s blackjackChallenge run scoreboard players set @s blackjackChallenge 0
execute if score @s money < @s blackjackChallenge run return 1

# Find nearest player and check if they're available
execute at @s as @p[distance=0.1..5] if score @s blackjackStart matches 0 if score @s blackjack.game_phase matches 0 run tag @s add challenge_target
execute unless entity @a[tag=challenge_target] run tellraw @s {"text":"Nearest player is already in a game!","color":"red"}
execute unless entity @a[tag=challenge_target] run scoreboard players set @s blackjackChallenge 0
execute unless entity @a[tag=challenge_target] run return 1

# Check if target has enough money
execute as @a[tag=challenge_target] if score @s money < @p[tag=!challenge_target] blackjackChallenge run tellraw @p[tag=!challenge_target] {"text":"Target player doesn't have enough money!","color":"red"}
execute as @a[tag=challenge_target] if score @s money < @p[tag=!challenge_target] blackjackChallenge run scoreboard players set @p[tag=!challenge_target] blackjackChallenge 0
execute as @a[tag=challenge_target] if score @s money < @p[tag=!challenge_target] blackjackChallenge run tag @a remove challenge_target
execute as @a[tag=challenge_target] if score @s money < @p[tag=!challenge_target] blackjackChallenge run return 1

# Send challenge
scoreboard players operation @a[tag=challenge_target] blackjack.challenger = @s dummy
scoreboard players operation @a[tag=challenge_target] blackjack.challenged = @a[tag=challenge_target] dummy
tellraw @a[tag=challenge_target] [{"selector":"@s"},{"text":" challenges you to blackjack for "},{"score":{"name":"@s","objective":"blackjackChallenge"},"color":"green"},{"text":" money! Use /trigger blackjackAccept or /trigger blackjackDecline"}]
tellraw @s [{"text":"Challenge sent to "},{"selector":"@a[tag=challenge_target]"},{"text":"!"}]

tag @a remove challenge_target
scoreboard players set @s blackjackChallenge 0