# File: functions/economy/treasurer/set_tax_rate.mcfunction

# Check if player is OP (additional security)
execute unless entity @s[tag=op] run tellraw @s {"text":"❌ Only server operators can set tax rates","color":"red"}
execute unless entity @s[tag=op] run scoreboard players set @s setTaxRate 0
execute unless entity @s[tag=op] run return fail

# Validate range (1-20%)
execute if score @s setTaxRate matches ..0 run tellraw @s {"text":"❌ Tax rate must be at least 1%","color":"red"}
execute if score @s setTaxRate matches 21.. run tellraw @s {"text":"❌ Tax rate cannot exceed 20%","color":"red"}

# Set tax rate if valid
execute if score @s setTaxRate matches 1..20 run scoreboard players operation #taxRate taxRate = @s setTaxRate
execute if score @s setTaxRate matches 1..20 run tellraw @a [{"text":"📢 Tax rate changed to ","color":"yellow"},{"score":{"name":"@s","objective":"setTaxRate"},"color":"gold"},{"text":"% by ","color":"yellow"},{"selector":"@s","color":"white"}]

# Reset trigger
scoreboard players set @s setTaxRate 0