# Player wants to sell blacksmith stock
# Format: /trigger sellBlacksmithStock set <shares>

# Store requested amount
scoreboard players operation @s tradeAmount = @s sellBlacksmithStock

# Calculate value (price * shares * 0.95 after commission)
scoreboard players operation @s tradeCost = #blacksmithStock blacksmithStockPrice
scoreboard players operation @s tradeCost *= @s tradeAmount
scoreboard players operation @s commission = @s tradeCost
scoreboard players set @s stockTemp 20
scoreboard players operation @s commission /= @s stockTemp
scoreboard players operation @s tradeCost -= @s commission

# Check if player has enough shares
execute if score @s blacksmithShares >= @s tradeAmount run scoreboard players operation @s blacksmithShares -= @s tradeAmount
execute if score @s blacksmithShares >= @s tradeAmount run scoreboard players operation @s money += @s tradeCost
execute if score @s blacksmithShares >= @s tradeAmount run scoreboard players operation #cityBank cityBank += @s commission
execute if score @s blacksmithShares >= @s tradeAmount run scoreboard players operation #blacksmithStock blacksmithSellPressure += @s tradeAmount
execute if score @s blacksmithShares >= @s tradeAmount run tellraw @s [{"text":"✓ Sold ","color":"green"},{"score":{"name":"@s","objective":"tradeAmount"},"color":"white"},{"text":" Blacksmith shares for $","color":"green"},{"score":{"name":"@s","objective":"tradeCost"},"color":"white"},{"text":" (after $","color":"gray"},{"score":{"name":"@s","objective":"commission"},"color":"white"},{"text":" commission)","color":"gray"}]

# Enhanced insufficient shares message
execute unless score @s blacksmithShares >= @s tradeAmount run tellraw @s [{"text":"✗ Insufficient shares!","color":"red"}]
execute unless score @s blacksmithShares >= @s tradeAmount run tellraw @s [{"text":"You own: ","color":"yellow"},{"score":{"name":"@s","objective":"blacksmithShares"},"color":"white"},{"text":" Blacksmith shares","color":"yellow"}]
execute unless score @s blacksmithShares >= @s tradeAmount run tellraw @s [{"text":"You tried to sell: ","color":"yellow"},{"score":{"name":"@s","objective":"tradeAmount"},"color":"white"},{"text":" shares","color":"yellow"}]
execute unless score @s blacksmithShares >= @s tradeAmount run scoreboard players operation @s shareValue = @s tradeAmount
execute unless score @s blacksmithShares >= @s tradeAmount run scoreboard players operation @s shareValue -= @s blacksmithShares
execute unless score @s blacksmithShares >= @s tradeAmount run tellraw @s [{"text":"You need ","color":"red"},{"score":{"name":"@s","objective":"shareValue"},"color":"white"},{"text":" more shares!","color":"red"}]

# Reset trigger
scoreboard players set @s sellBlacksmithStock 0
scoreboard players enable @s sellBlacksmithStock