/*
 * Decompiled with CFR 0.152.
 */
package net.gobies.manacrystals.item;

import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.gobies.manacrystals.CommonConfig;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManaCrystalItem
extends Item {
    private static final String USE_COUNT_TAG = "ManaCrystalUseCount";
    public static final String GLOBAL_USE_COUNT_TAG = "GlobalManaCrystalUseCount";
    private static final long COOLDOWN_DURATION = 20L;
    private static final String LAST_USE_TAG = "ManaCrystalLastUseTime";
    private static int maxUses;

    public ManaCrystalItem(Item.Properties properties) {
        super(properties);
    }

    public static int getMaxUses() {
        if (maxUses == 0) {
            maxUses = (Integer)CommonConfig.MANA_CRYSTAL_MAX_USES.get();
        }
        return maxUses;
    }

    public static double getManaIncrease() {
        return (Double)CommonConfig.MANA_CRYSTAL_MANA_INCREASE.get();
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand handIn) {
        ItemStack stack = player.m_21120_(handIn);
        CompoundTag stackTag = stack.m_41784_();
        int stackUseCount = stackTag.m_128451_(USE_COUNT_TAG);
        CompoundTag playerData = player.getPersistentData();
        CompoundTag modData = playerData.m_128469_("ManaCrystalModData");
        int globalUseCount = modData.m_128451_(GLOBAL_USE_COUNT_TAG);
        long lastUseTime = modData.m_128454_(LAST_USE_TAG);
        long currentTime = level.m_46467_();
        if (currentTime - lastUseTime < 20L) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (globalUseCount < ManaCrystalItem.getMaxUses() && !level.f_46443_) {
            SoundEvent manaCrystalUse;
            modData.m_128405_(GLOBAL_USE_COUNT_TAG, ++globalUseCount);
            playerData.m_128365_("ManaCrystalModData", (Tag)modData);
            lastUseTime = currentTime;
            modData.m_128356_(LAST_USE_TAG, lastUseTime);
            UUID uniqueUUID = UUID.nameUUIDFromBytes(("ManaCrystalManaIncrease" + globalUseCount).getBytes());
            Objects.requireNonNull(player.m_21204_().m_22146_((Attribute)AttributeRegistry.MAX_MANA.get())).m_22125_(new AttributeModifier(uniqueUUID, "ManaCrystalManaIncrease", ManaCrystalItem.getManaIncrease(), AttributeModifier.Operation.ADDITION));
            if (stackUseCount < ManaCrystalItem.getMaxUses()) {
                stackTag.m_128405_(USE_COUNT_TAG, ++stackUseCount);
            }
            if ((manaCrystalUse = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("manacrystals:mana_crystal_use"))) != null) {
                level.m_5594_(null, player.m_20183_(), manaCrystalUse, SoundSource.PLAYERS, 1.0f, 1.0f);
                stack.m_41774_(1);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            if (globalUseCount >= ManaCrystalItem.getMaxUses()) {
                player.m_5661_((Component)Component.m_237115_((String)"message.manacrystals.max_uses"), true);
                return InteractionResultHolder.m_19100_((Object)stack);
            }
        }
        return InteractionResultHolder.m_19100_((Object)player.m_21120_(handIn));
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.manacrystal.item"));
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }
}

