/*
 * Decompiled with CFR 0.152.
 */
package com.example.alwaysbacktank.client;

import com.example.alwaysbacktank.Config;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class AirOverlay {
    private static final ResourceLocation OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"create", (String)"textures/gui/remaining_air_overlay.png");

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiOverlayEvent.Post event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || mc.f_91066_.f_92062_) {
            return;
        }
        List backtanks = BacktankUtil.getAllWithAir((LivingEntity)player);
        if (backtanks.isEmpty()) {
            return;
        }
        int totalAir = 0;
        for (ItemStack tank : backtanks) {
            totalAir = (int)((float)totalAir + BacktankUtil.getAir((ItemStack)tank));
        }
        if (totalAir <= 0) {
            return;
        }
        GuiGraphics guiGraphics = event.getGuiGraphics();
        RenderSystem.enableBlend();
        mc.m_91097_().m_174784_(OVERLAY);
        int width = mc.m_91268_().m_85445_();
        int height = mc.m_91268_().m_85446_();
        int x = width / 2 + Config.overlayX;
        int y = height - Config.overlayY;
        int seconds = totalAir - 1;
        int minutes = seconds / 60;
        int secs = seconds % 60;
        int min = minutes % 60;
        int hours = minutes / 60;
        String timeString = hours > 0 ? String.format("%d:%02d:%02d", hours, min, secs) : String.format("%02d:%02d", min, secs);
        int textX = x + 20;
        int textY = y + 4;
        if (!AirOverlay.backtankvis()) {
            guiGraphics.m_280614_(mc.f_91062_, (Component)Component.m_237113_((String)timeString), textX, textY, 0xFFFFFF, true);
        }
        RenderSystem.disableBlend();
    }

    public static boolean backtankvis() {
        boolean canBreathe;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92062_ || mc.f_91072_.m_105295_() == GameType.SPECTATOR) {
            return false;
        }
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return false;
        }
        if (player.m_7500_()) {
            return false;
        }
        if (!player.getPersistentData().m_128441_("VisualBacktankAir")) {
            return false;
        }
        boolean isAir = player.getEyeInFluidType().isAir() || player.m_9236_().m_8055_(BlockPos.m_274561_((double)player.m_20185_(), (double)player.m_20188_(), (double)player.m_20189_())).m_60713_(Blocks.f_50628_);
        boolean bl = canBreathe = !player.canDrownInFluidType(player.getEyeInFluidType()) || MobEffectUtil.m_19588_((LivingEntity)player) || player.m_150110_().f_35934_;
        return !isAir && !canBreathe || player.m_20077_();
    }
}

