package com.github.vini2003.linkart.utility;

import com.github.vini2003.linkart.configuration.LinkartConfiguration;
import net.minecraft.class_1269;
import net.minecraft.class_1688;
import net.minecraft.class_1799;

public record CartOperation(Type type, class_1688 minecart) {

    public enum Type {
        LINKING {
            @Override
            public class_1269 perform(class_1688 minecart, CartOperation operation, class_1799 stack) {
                if (minecart.linkart$getFollower() == operation.minecart()) return class_1269.field_5814; //Linking a parent cart to its follower.
                if (minecart.linkart$getFollowing() != null) return class_1269.field_5814; //Linking to an already linked cart.
                if (Math.abs(minecart.method_5739(operation.minecart()) - 1) > LinkartConfiguration.pathfindingDistance)
                    return class_1269.field_5814; //Linking beyond pathfindingDistance, will just break on first tick.

                //Leading minecarts must never be linked to a follower. This creates an immovable object or an Ouroboros, if you will.
                if (minecart.linkart$getFollower() != null && minecart.linkart$getFollowing() == null) {
                    var temp = minecart;
                    while (temp != null) {
                        if (temp == operation.minecart()) return class_1269.field_5814;
                        temp = temp.linkart$getFollower();
                    }
                }

                CartUtils.linkTo(minecart, operation.minecart(), stack);
                return class_1269.field_5812;
            }
        },
        UNLINKING {
            @Override
            public class_1269 perform(class_1688 minecart, CartOperation operation, class_1799 stack) {
                if (operation.minecart().linkart$getFollower() != minecart) return class_1269.field_5814;

                CartUtils.unlinkFromParent(minecart);
                return class_1269.field_5812;
            }
        };

        public abstract class_1269 perform(class_1688 minecart, CartOperation operation, class_1799 stack);
    }
}
