package com.github.vini2003.linkart.utility;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_10741;
import net.minecraft.class_1688;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3230;

public class LoadingCarts extends class_18 {

    /*? if <1.21.5*/
    /*private static final Type<LoadingCarts> TYPE = new Type<>(LoadingCarts::new, (compound, lookup) -> new LoadingCarts().readNbt(compound), null);*///thanks, FAPI
    /*? if >=1.21.5 {*/
    private static final Codec<LoadingCarts> CODEC = RecordCodecBuilder.create(
        instance -> instance.group(
            class_2338.field_25064.listOf().fieldOf("chunksToSave").forGetter(carts -> carts.chunksToReload.stream().toList())
        ).apply(instance, LoadingCarts::new)
    );

    private static final class_10741<LoadingCarts> TYPE = new class_10741<LoadingCarts>(
        "linkart_loading_carts", LoadingCarts::new, CODEC, null
    );
    /*?}*/

    public static LoadingCarts getOrCreate(class_3218 world) {
        return world.method_17983().method_17924(TYPE/*? if <1.21.5 {*//*, "linkart_loading_carts"*//*?}*/);
    }

    private final Set<class_2338> chunksToReload = new HashSet<>();
    private final Set<class_1688> cartsToBlockPos = new HashSet<>();

    public LoadingCarts() { this(List.of()); }

    public LoadingCarts(Collection<class_2338> chunksToReload) {
        this.chunksToReload.addAll(chunksToReload);
    }

    /*? if <1.21.5 {*/
    /*@Override
    public NbtCompound writeNbt(NbtCompound nbt, RegistryWrapper.WrapperLookup registryLookup) {
        NbtList list = new NbtList();
        for (AbstractMinecartEntity minecart : cartsToBlockPos) {
            if (!minecart.isRemoved()) list.add(NbtLong.of(minecart.getBlockPos().asLong()));
        }
        nbt.put("chunksToSave", list);
        cartsToBlockPos.clear();
        return nbt;
    }

    public LoadingCarts readNbt(NbtCompound nbt) {
        NbtList list = nbt.getList("chunksToSave", NbtElement.LONG_TYPE);
        for (NbtElement element : list) {
            chunksToReload.add(BlockPos.fromLong(((NbtLong) element).longValue()));
        }
        return this;
    }
    *//*?}*/

    public void tick(class_3218 world) {
        if (!chunksToReload.isEmpty()) {
            for (class_2338 pos : chunksToReload) {
                class_1923 chunkPos = new class_1923(pos);
                world.method_14178().method_66009(class_3230.field_19280, chunkPos, 4/*? if <1.21.5 {*//*, pos*//*?}*/);
            }
            chunksToReload.clear();
            method_80();
        }
    }


    public void addCart(class_1688 cart) {
        cartsToBlockPos.add(cart);
        method_80();
    }

    public void removeCart(class_1688 cart) {
        cartsToBlockPos.remove(cart);
        method_80();
    }
}
