package com.github.vini2003.linkart.utility;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.HashSet;
import java.util.Set;
//? if >=1.21.5
/*import net.minecraft.world.PersistentStateType;*/
import net.minecraft.class_1688;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2503;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3230;
import net.minecraft.class_7225;

public class LoadingCarts extends class_18 {

    /*? if <1.21.5*/
    private static final class_8645<LoadingCarts> TYPE = new class_8645<>(LoadingCarts::new, (compound, lookup) -> new LoadingCarts().readNbt(compound), null);//thanks, FAPI
    /*? if >=1.21.5 {*/
    /*private static final Codec<LoadingCarts> CODEC = RecordCodecBuilder.create(
        instance -> instance.group(
            BlockPos.CODEC.listOf().fieldOf("chunksToSave").forGetter(carts -> carts.chunksToReload.stream().toList())
        ).apply(instance, LoadingCarts::new)
    );

    private static final PersistentStateType<LoadingCarts> TYPE = new PersistentStateType<LoadingCarts>(
        "linkart_loading_carts", LoadingCarts::new, CODEC, null
    );
    *//*?}*/

    public static LoadingCarts getOrCreate(class_3218 world) {
        return world.method_17983().method_17924(TYPE/*? if <1.21.5 {*/, "linkart_loading_carts"/*?}*/);
    }

    private final Set<class_2338> chunksToReload = new HashSet<>();
    private final Set<class_1688> cartsToBlockPos = new HashSet<>();

    public LoadingCarts() { this(List.of()); }

    public LoadingCarts(Collection<class_2338> chunksToReload) {
        this.chunksToReload.addAll(chunksToReload);
    }

    /*? if <1.21.5 {*/
    @Override
    public class_2487 method_75(class_2487 nbt, class_7225.class_7874 registryLookup) {
        class_2499 list = new class_2499();
        for (class_1688 minecart : cartsToBlockPos) {
            if (!minecart.method_31481()) list.add(class_2503.method_23251(minecart.method_24515().method_10063()));
        }
        nbt.method_10566("chunksToSave", list);
        cartsToBlockPos.clear();
        return nbt;
    }

    public LoadingCarts readNbt(class_2487 nbt) {
        class_2499 list = nbt.method_10554("chunksToSave", class_2520.field_33254);
        for (class_2520 element : list) {
            chunksToReload.add(class_2338.method_10092(((class_2503) element).method_10699()));
        }
        return this;
    }
    /*?}*/

    public void tick(class_3218 world) {
        if (!chunksToReload.isEmpty()) {
            for (class_2338 pos : chunksToReload) {
                class_1923 chunkPos = new class_1923(pos);
                world.method_14178().method_17297(class_3230.field_19280, chunkPos, 4/*? if <1.21.5 {*/, pos/*?}*/);
            }
            chunksToReload.clear();
            method_80();
        }
    }


    public void addCart(class_1688 cart) {
        cartsToBlockPos.add(cart);
        method_80();
    }

    public void removeCart(class_1688 cart) {
        cartsToBlockPos.remove(cart);
        method_80();
    }
}
