/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import me.teakivy.teakstweaks.utils.Credits;
import me.teakivy.teakstweaks.utils.JsonManager;
import me.teakivy.teakstweaks.utils.config.Config;
import me.teakivy.teakstweaks.utils.gui.GUIListener;
import me.teakivy.teakstweaks.utils.lang.TranslationManager;
import me.teakivy.teakstweaks.utils.log.Logger;
import me.teakivy.teakstweaks.utils.metrics.CustomMetrics;
import me.teakivy.teakstweaks.utils.metrics.Metrics;
import me.teakivy.teakstweaks.utils.papi.PAPIExpansion;
import me.teakivy.teakstweaks.utils.permission.PermissionManager;
import me.teakivy.teakstweaks.utils.recipe.RecipeManager;
import me.teakivy.teakstweaks.utils.register.Register;
import me.teakivy.teakstweaks.utils.update.UpdateChecker;
import me.teakivy.teakstweaks.utils.update.UpdateJoinAlert;
import me.teakivy.teakstweaks.utils.update.VersionManager;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class TeaksTweaks
extends JavaPlugin
implements Listener {
    private final ArrayList<String> activePacks = new ArrayList();
    private final ArrayList<String> activeCraftingTweaks = new ArrayList();
    private TranslationManager translationManager;

    public void onEnable() {
        VersionManager.init();
        this.createCredits();
        this.createDataFolders();
        PermissionManager.init();
        Config.init();
        this.translationManager = new TranslationManager(this.getDataFolder());
        this.translationManager.initialize();
        if (Config.getBoolean("settings.disable-update-checker")) {
            Logger.info((Component)Component.translatable((String)"startup.update.disabled"));
        } else {
            this.getServer().getPluginManager().registerEvents((Listener)new UpdateJoinAlert(), (Plugin)this);
        }
        this.getServer().getPluginManager().registerEvents((Listener)new GUIListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new RecipeManager(), (Plugin)this);
        Bukkit.getScheduler().runTaskLater((Plugin)this, UpdateChecker::sendUpdateMessage, 60L);
        Register.registerAll();
        Logger.info(TeaksTweaks.newText(" "));
        Logger.info((Component)Component.text((String)TranslationManager.getString(Config.getLanguage(), "startup.plugin.started").replace("\\<version>", this.getPluginMeta().getVersion())));
        Logger.info(TeaksTweaks.newText(" "));
        this.removeDataFile();
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new PAPIExpansion(this).register();
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
            Metrics metrics = new Metrics(this, 12001);
            CustomMetrics.registerCustomMetrics(metrics);
        }, 600L);
    }

    public void onDisable() {
        Logger.info((Component)Component.translatable((String)"startup.plugin.shutting_down"));
    }

    public void clearPacks() {
        this.activePacks.clear();
    }

    public void addPack(String name) {
        this.activePacks.add(name);
    }

    public ArrayList<String> getPacks() {
        return this.activePacks;
    }

    public void addCraftingTweaks(String name) {
        this.activeCraftingTweaks.add(name);
    }

    public ArrayList<String> getCraftingTweaks() {
        return this.activeCraftingTweaks;
    }

    public static TeaksTweaks getInstance() {
        return (TeaksTweaks)TeaksTweaks.getPlugin(TeaksTweaks.class);
    }

    public static TranslationManager getTranslationManager() {
        return TeaksTweaks.getInstance().translationManager;
    }

    private void createCredits() {
        try {
            new Credits().createCredits();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Gson getGson() {
        return JsonManager.getGson();
    }

    private void removeDataFile() {
        File file = new File(this.getDataFolder(), "data.yml");
        if (file.exists()) {
            file.delete();
        }
    }

    public static Component newText(String text) {
        return MiniMessage.miniMessage().deserialize((Object)text);
    }

    public void createDataFolders() {
        File packsFolder;
        File dataFolder = new File(this.getDataFolder(), "data");
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
        }
        if (!(packsFolder = new File(this.getDataFolder(), "lang")).exists()) {
            packsFolder.mkdirs();
        }
    }
}

