/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.List;
import java.util.UUID;
import me.teakivy.teakstweaks.packs.spectatoralts.SpectatorAlts;
import me.teakivy.teakstweaks.utils.ErrorType;
import me.teakivy.teakstweaks.utils.command.AbstractCommand;
import me.teakivy.teakstweaks.utils.permission.Permission;
import me.teakivy.teakstweaks.utils.register.TTCommand;
import net.kyori.adventure.text.ComponentLike;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class AltsCommand
extends AbstractCommand {
    public AltsCommand() {
        super(TTCommand.ALTS, "alts");
    }

    @Override
    public LiteralCommandNode<CommandSourceStack> getCommand() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"alts").requires(this.perm(Permission.COMMAND_ALTS))).then(((LiteralArgumentBuilder)Commands.literal((String)"list").executes(ctx -> {
            Player player = this.checkPlayer((CommandContext<CommandSourceStack>)ctx);
            if (player == null) {
                return 1;
            }
            this.list(player, player.getUniqueId());
            return 1;
        })).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            Player player = this.checkPlayer((CommandContext<CommandSourceStack>)ctx);
            if (player == null) {
                return 1;
            }
            String name = (String)ctx.getArgument("player", String.class);
            UUID uuid = this.getUUID(name);
            if (uuid == null) {
                player.sendMessage(ErrorType.PLAYER_DNE.m());
                return 1;
            }
            if (uuid != player.getUniqueId() && !player.hasPermission(Permission.COMMAND_ALTS_MANAGE.getPermission())) {
                player.sendMessage(this.getError("no_permission_modify_others", new ComponentLike[0]));
                return 1;
            }
            this.list(player, uuid);
            return 1;
        })))).then(Commands.literal((String)"add").then(((RequiredArgumentBuilder)Commands.argument((String)"alt", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            Player player = this.checkPlayer((CommandContext<CommandSourceStack>)ctx);
            if (player == null) {
                return 1;
            }
            String name = (String)ctx.getArgument("alt", String.class);
            UUID alt = this.getUUID(name);
            this.add(player, player.getUniqueId(), alt);
            return 1;
        })).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            Player player = this.checkPlayer((CommandContext<CommandSourceStack>)ctx);
            if (player == null) {
                return 1;
            }
            String altName = (String)ctx.getArgument("alt", String.class);
            UUID alt = this.getUUID(altName);
            String mainName = (String)ctx.getArgument("player", String.class);
            UUID main = this.getUUID(mainName);
            if (main != null && !main.equals(player.getUniqueId()) && !player.hasPermission(Permission.COMMAND_ALTS_MANAGE.getPermission())) {
                player.sendMessage(this.getError("no_permission_modify_others", new ComponentLike[0]));
                return 1;
            }
            this.add(player, main, alt);
            return 1;
        }))))).then(Commands.literal((String)"remove").then(((RequiredArgumentBuilder)Commands.argument((String)"alt", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            Player player = this.checkPlayer((CommandContext<CommandSourceStack>)ctx);
            if (player == null) {
                return 1;
            }
            String name = (String)ctx.getArgument("alt", String.class);
            UUID alt = this.getUUID(name);
            this.remove(player, player.getUniqueId(), alt);
            return 1;
        })).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            Player player = this.checkPlayer((CommandContext<CommandSourceStack>)ctx);
            if (player == null) {
                return 1;
            }
            String altName = (String)ctx.getArgument("alt", String.class);
            UUID alt = this.getUUID(altName);
            String mainName = (String)ctx.getArgument("player", String.class);
            UUID main = this.getUUID(mainName);
            if (main != null && !main.equals(player.getUniqueId()) && !player.hasPermission(Permission.COMMAND_ALTS_MANAGE.getPermission())) {
                player.sendMessage(this.getError("no_permission_modify_others", new ComponentLike[0]));
                return 1;
            }
            this.remove(player, main, alt);
            return 1;
        }))))).build();
    }

    private void list(Player player, UUID uuid) {
        List<UUID> alts = SpectatorAlts.getAlts(uuid);
        if (alts.isEmpty()) {
            player.sendMessage(this.getError("no_alts", this.insert("player", this.getName(uuid))));
            return;
        }
        player.sendMessage(this.getText("list_alts", this.insert("player", this.getName(uuid))));
        for (UUID altAcc : alts) {
            player.sendMessage(this.getText("listed_alt", this.insert("alt", this.getName(altAcc))));
        }
    }

    private void add(Player player, UUID main, UUID alt) {
        if (main == null || alt == null) {
            player.sendMessage(ErrorType.PLAYER_DNE.m());
            return;
        }
        if (main.equals(alt)) {
            player.sendMessage(this.getError("self", new ComponentLike[0]));
            return;
        }
        if (!this.canAddAlt(player)) {
            player.sendMessage(this.getError("max_alts", new ComponentLike[0]));
            return;
        }
        for (OfflinePlayer whitelisted : Bukkit.getWhitelistedPlayers()) {
            if (!whitelisted.getUniqueId().equals(alt)) continue;
            player.sendMessage(this.getError("whitelisted", new ComponentLike[0]));
            return;
        }
        if (SpectatorAlts.isAlt(alt)) {
            player.sendMessage(this.getError("already_alt", this.insert("alt", this.getName(alt))));
            return;
        }
        SpectatorAlts.addAlt(main, alt);
        player.sendMessage(this.getText("added_alt", this.insert("alt", this.getName(alt)), this.insert("player", this.getName(main))));
    }

    private void remove(Player player, UUID main, UUID alt) {
        if (main == null || alt == null) {
            player.sendMessage(ErrorType.PLAYER_DNE.m());
            return;
        }
        if (!SpectatorAlts.isAlt(alt)) {
            player.sendMessage(this.getError("not_alt", this.insert("alt", this.getName(alt))));
            return;
        }
        SpectatorAlts.removeAlt(alt);
        player.sendMessage(this.getText("removed_alt", this.insert("alt", this.getName(alt)), this.insert("player", this.getName(main))));
    }

    private String getName(UUID uuid) {
        OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)uuid);
        if (player.getName() == null) {
            return uuid.toString();
        }
        return player.getName();
    }

    public boolean canAddAlt(Player player) {
        if (player.isOp()) {
            return true;
        }
        if (this.getPackConfig().getInt("max-alts") == -1) {
            return true;
        }
        return SpectatorAlts.getAlts(player.getUniqueId()).size() < this.getPackConfig().getInt("max-alts");
    }

    private UUID getUUID(String name) {
        for (OfflinePlayer p : Bukkit.getOfflinePlayers()) {
            if (p.getName() == null || !p.getName().equalsIgnoreCase(name)) continue;
            return p.getUniqueId();
        }
        return null;
    }
}

