/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import me.teakivy.teakstweaks.TeaksTweaks;
import me.teakivy.teakstweaks.packs.back.Back;
import me.teakivy.teakstweaks.utils.command.AbstractCommand;
import me.teakivy.teakstweaks.utils.permission.Permission;
import me.teakivy.teakstweaks.utils.register.TTCommand;
import net.kyori.adventure.text.ComponentLike;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class BackCommand
extends AbstractCommand {
    public BackCommand() {
        super(TTCommand.BACK, "back");
        this.setCooldownTime(this.getPackConfig().getInt("teleport-cooldown"));
    }

    @Override
    public LiteralCommandNode<CommandSourceStack> getCommand() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"back").requires(this.perm(Permission.COMMAND_BACK))).executes(this.playerOnly(this::back))).build();
    }

    private int back(CommandContext<CommandSourceStack> context) {
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        if (this.isOnCooldown(player)) {
            player.sendMessage(this.getText("on_cooldown", this.insert("cooldown_seconds", this.getCooldownTime())));
            return 1;
        }
        if (!Back.backLoc.containsKey(player.getUniqueId())) {
            player.sendMessage(this.getError("no_back_location", new ComponentLike[0]));
            return 1;
        }
        int teleportDelay = this.getPackConfig().getInt("teleport-delay");
        if (teleportDelay <= 0) {
            Back.tpBack(player);
            player.sendMessage(this.getText("teleporting", new ComponentLike[0]));
            return 1;
        }
        player.sendMessage(this.getText("teleporting_delayed", this.insert("time", teleportDelay)));
        int x = player.getLocation().getBlockX();
        int y = player.getLocation().getBlockY();
        int z = player.getLocation().getBlockZ();
        Bukkit.getScheduler().runTaskLater((Plugin)TeaksTweaks.getInstance(), () -> {
            if (x != player.getLocation().getBlockX() || y != player.getLocation().getBlockY() || z != player.getLocation().getBlockZ()) {
                player.sendMessage(this.getError("teleport_moved", new ComponentLike[0]));
                this.resetCooldown(player);
                return;
            }
            Back.tpBack(player);
            player.sendMessage(this.getText("teleporting", new ComponentLike[0]));
        }, (long)teleportDelay * 20L);
        this.setCooldown(player);
        return 1;
    }
}

