/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.Objects;
import me.teakivy.teakstweaks.TeaksTweaks;
import me.teakivy.teakstweaks.packs.back.Back;
import me.teakivy.teakstweaks.utils.command.AbstractCommand;
import me.teakivy.teakstweaks.utils.permission.Permission;
import me.teakivy.teakstweaks.utils.register.TTCommand;
import net.kyori.adventure.text.ComponentLike;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class BedCommand
extends AbstractCommand {
    public BedCommand() {
        super(TTCommand.BED, "back_to_bed");
        this.setCooldownTime(this.getPackConfig().getInt("teleport-cooldown"));
    }

    @Override
    public LiteralCommandNode<CommandSourceStack> getCommand() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"bed").requires(this.perm(Permission.COMMAND_BED))).executes(this.playerOnly(this::bed))).build();
    }

    private int bed(CommandContext<CommandSourceStack> context) {
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        if (this.isOnCooldown(player)) {
            player.sendMessage(this.getError("on_cooldown", this.insert("time", this.getCooldownTime())));
            return 1;
        }
        this.teleportToBed(player);
        this.setCooldown(player);
        return 1;
    }

    private void teleportToBed(Player player) {
        Location location = this.getBedLocation(player);
        if (location == null) {
            player.sendMessage(this.getError("no_respawn", new ComponentLike[0]));
            return;
        }
        int teleportDelay = this.getPackConfig().getInt("teleport-delay");
        if (teleportDelay <= 0) {
            Back.backLoc.put(player.getUniqueId(), player.getLocation());
            player.teleportAsync(location);
            player.sendMessage(this.getText("teleporting", new ComponentLike[0]));
            return;
        }
        player.sendMessage(this.getText("teleporting_delayed", this.insert("time", teleportDelay)));
        int x = player.getLocation().getBlockX();
        int y = player.getLocation().getBlockY();
        int z = player.getLocation().getBlockZ();
        Bukkit.getScheduler().runTaskLater((Plugin)TeaksTweaks.getInstance(), () -> {
            if (x != player.getLocation().getBlockX() || y != player.getLocation().getBlockY() || z != player.getLocation().getBlockZ()) {
                player.sendMessage(this.getError("teleport_moved", new ComponentLike[0]));
                this.resetCooldown(player);
                return;
            }
            Back.backLoc.put(player.getUniqueId(), player.getLocation());
            player.teleportAsync(location);
            player.sendMessage(this.getText("teleporting", new ComponentLike[0]));
        }, (long)teleportDelay * 20L);
    }

    private Location getBedLocation(Player player) {
        Location loc = player.getRespawnLocation(true);
        if (loc == null && this.getPackConfig().getBoolean("to-spawn")) {
            World world = Bukkit.getWorld((String)Objects.requireNonNull(this.getPackConfig().getString("world")));
            if (world == null) {
                return null;
            }
            loc = world.getSpawnLocation();
        }
        return loc;
    }
}

