/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import me.teakivy.teakstweaks.packs.durabilityping.DuraPingOption;
import me.teakivy.teakstweaks.packs.durabilityping.DurabilityPing;
import me.teakivy.teakstweaks.utils.command.AbstractCommand;
import me.teakivy.teakstweaks.utils.lang.TranslationManager;
import me.teakivy.teakstweaks.utils.permission.Permission;
import me.teakivy.teakstweaks.utils.register.TTCommand;
import net.kyori.adventure.text.ComponentLike;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class DurabilityPingCommand
extends AbstractCommand {
    public DurabilityPingCommand() {
        super(TTCommand.DURABILITYPING, "durabilityping", List.of("duraping"));
    }

    @Override
    public LiteralCommandNode<CommandSourceStack> getCommand() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"durabilityping").requires(this.perm(Permission.COMMAND_DURABILITYPING))).executes(this.playerOnly(this::durabilityping))).then(Commands.literal((String)"preview").then(((RequiredArgumentBuilder)Commands.argument((String)"option", (ArgumentType)StringArgumentType.word()).requires(this.perm(Permission.COMMAND_DURABILITYPING_PREVIEW))).suggests(DurabilityPingCommand.createSuggestions(List.of("ping_with_sound", "display_subtitle", "display_title", "display_chat", "display_actionbar"))).executes(this.playerOnly(this::preview))))).then(Commands.literal((String)"set").then(Commands.argument((String)"option", (ArgumentType)StringArgumentType.word()).suggests(DurabilityPingCommand.createSuggestions(List.of("ping_for_hand_items", "ping_for_armor_items", "ping_with_sound", "display"))).then(((RequiredArgumentBuilder)Commands.argument((String)"value", (ArgumentType)StringArgumentType.word()).suggests(this::valueSuggestions).requires(this.perm(Permission.COMMAND_DURABILITYPING_SET))).executes(this.playerOnly(this::set)))))).build();
    }

    private int durabilityping(CommandContext<CommandSourceStack> context) {
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        this.sendDuraPingConfig(player);
        return 1;
    }

    private int preview(CommandContext<CommandSourceStack> context) {
        String option;
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        switch (option = (String)context.getArgument("option", String.class)) {
            case "ping_with_sound": {
                player.playSound(player.getLocation(), Sound.BLOCK_ANVIL_LAND, 1.0f, 2.0f);
                break;
            }
            case "display_subtitle": {
                DurabilityPing.pingPlayer(player, new ItemStack(Material.DIAMOND_PICKAXE), 156.0f, "subtitle", false);
                break;
            }
            case "display_title": {
                DurabilityPing.pingPlayer(player, new ItemStack(Material.DIAMOND_PICKAXE), 156.0f, "title", false);
                break;
            }
            case "display_chat": {
                DurabilityPing.pingPlayer(player, new ItemStack(Material.DIAMOND_PICKAXE), 156.0f, "chat", false);
                break;
            }
            case "display_actionbar": {
                DurabilityPing.pingPlayer(player, new ItemStack(Material.DIAMOND_PICKAXE), 156.0f, "actionbar", false);
            }
        }
        return 1;
    }

    private int set(CommandContext<CommandSourceStack> context) {
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        String option = (String)context.getArgument("option", String.class);
        String value = (String)context.getArgument("value", String.class);
        DuraPingOption duraPingOption = DuraPingOption.fromString(option);
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"PING_FOR_HAND_ITEMS", "PING_FOR_ARMOR_ITEMS", "PING_WITH_SOUND", "DISPLAY"}, (DuraPingOption)duraPingOption, n)) {
            case 0: 
            case 1: 
            case 2: {
                this.setScoreboardTag(player, DuraPingOption.fromString(option), value);
                break;
            }
            case 3: {
                this.setDisplayTag(player, value);
                break;
            }
            default: {
                player.sendMessage(this.getError("missing_set_selection", new ComponentLike[0]));
            }
        }
        this.sendDuraPingConfig(player);
        return 1;
    }

    public void sendDuraPingConfig(Player player) {
        this.sendStrike(player);
        this.sendOption(player, "ping_for_hand_items", false);
        this.sendOption(player, "ping_for_armor_items", false);
        this.sendOption(player, "ping_with_sound", true);
        this.sendOption(player, "display_hidden", false);
        this.sendOption(player, "display_subtitle", true);
        this.sendOption(player, "display_title", true);
        this.sendOption(player, "display_chat", true);
        this.sendOption(player, "display_actionbar", true);
        this.sendStrike(player);
    }

    public String newPreviewPanel(Player player, String command, String name) {
        return "<hover:show_text:\"" + TranslationManager.getString(player, "durabilityping.preview_panel.hover").replace("<name>", name) + "\"><click:run_command:" + command + "><gray>[ \u2139 ]</click></hover><reset> ";
    }

    public String createCheckBox(Player player, boolean checked, String command, String loreName, String loreDescription) {
        String replacement = loreName + (String)(loreDescription != null && loreDescription.contains("durabilityping.") ? "" : "<newline><gray>" + loreDescription);
        String hover = "<hover:show_text:\"" + TranslationManager.getString(player, "durabilityping.checkbox." + (checked ? "yes" : "no") + ".hover") + "\">";
        String click = "<click:run_command:" + command + ">";
        return (hover + click + (checked ? "<green>[ \u2714 ]" : "<red>[ \u274c ]")).replace("<name>", replacement) + "</click></hover><reset> ";
    }

    private void setScoreboardTag(Player player, DuraPingOption option, String value) {
        if (value.equals("true")) {
            player.addScoreboardTag(option.getScoreboardTag());
        } else {
            player.removeScoreboardTag(option.getScoreboardTag());
        }
        player.addScoreboardTag("dp_customized");
    }

    private void setDisplayTag(Player player, String type) {
        player.removeScoreboardTag("dp_display_hidden");
        player.removeScoreboardTag("dp_display_subtitle");
        player.removeScoreboardTag("dp_display_title");
        player.removeScoreboardTag("dp_display_chat");
        player.removeScoreboardTag("dp_display_actionbar");
        player.addScoreboardTag("dp_display_" + type);
    }

    private void sendOption(Player player, String option, boolean preview) {
        Set tags = player.getScoreboardTags();
        String setCommand = "/duraping set " + option + " " + (tags.contains("dp_" + option) ? "false" : "true");
        if (option.contains("display_")) {
            setCommand = "/duraping set display " + option.replace("display_", "");
        }
        Object message = this.createCheckBox(player, tags.contains("dp_" + option), setCommand, TranslationManager.getString(player, "durabilityping.config." + option + ".name"), TranslationManager.getString(player, "durabilityping.config." + option + ".description"));
        if (preview) {
            message = (String)message + this.newPreviewPanel(player, "/duraping preview " + option, TranslationManager.getString(player, "durabilityping.config." + option + ".name"));
        }
        message = (String)message + TranslationManager.getString(player, "durabilityping.config." + option + ".name");
        player.sendRichMessage((String)message);
    }

    private void sendStrike(Player player) {
        player.sendRichMessage("<dark_gray><strikethrough>                                                                                ");
    }

    public CompletableFuture<Suggestions> valueSuggestions(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        builder.restart();
        ArrayList<String> values = new ArrayList<String>();
        if (((String)ctx.getArgument("option", String.class)).equals("display")) {
            values.add("hidden");
            values.add("subtitle");
            values.add("title");
            values.add("chat");
            values.add("actionbar");
        } else {
            values.add("true");
            values.add("false");
        }
        if (!(((CommandSourceStack)ctx.getSource()).getSender() instanceof Player)) {
            return builder.buildFuture();
        }
        for (String value : values) {
            if (!value.toLowerCase().startsWith(builder.getRemainingLowerCase())) continue;
            builder.suggest(value);
        }
        return builder.buildFuture();
    }
}

