/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import me.teakivy.teakstweaks.utils.ErrorType;
import me.teakivy.teakstweaks.utils.Key;
import me.teakivy.teakstweaks.utils.command.AbstractCommand;
import me.teakivy.teakstweaks.utils.customitems.TItem;
import me.teakivy.teakstweaks.utils.permission.Permission;
import me.teakivy.teakstweaks.utils.register.TTCommand;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class GraveCommand
extends AbstractCommand {
    public GraveCommand() {
        super(TTCommand.GRAVE, "grave");
    }

    @Override
    public LiteralCommandNode<CommandSourceStack> getCommand() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"grave").requires(this.perm(Permission.COMMAND_GRAVE))).then(((LiteralArgumentBuilder)Commands.literal((String)"locate").requires(this.perm(Permission.COMMAND_GRAVE_LOCATE))).executes(this.playerOnly(this::locate)))).then(((LiteralArgumentBuilder)Commands.literal((String)"key").requires(this.perm(Permission.COMMAND_GRAVE_KEY))).executes(this.playerOnly(this::key)))).then(((LiteralArgumentBuilder)Commands.literal((String)"uninstall").requires(this.perm(Permission.COMMAND_GRAVE_UNINSTALL))).executes(this.playerOnly(this::uninstall)))).build();
    }

    private int locate(CommandContext<CommandSourceStack> context) {
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        if (!this.getPackConfig().getBoolean("locatable")) {
            player.sendMessage(ErrorType.COMMAND_DISABLED.m());
            return 1;
        }
        PersistentDataContainer data = player.getPersistentDataContainer();
        if (!data.has(Key.get("graves_last"), PersistentDataType.STRING)) {
            player.sendMessage(this.getError("no_grave", new ComponentLike[0]));
            return 1;
        }
        String lastGraveRaw = (String)data.get(Key.get("graves_last"), PersistentDataType.STRING);
        assert (lastGraveRaw != null);
        String[] graveResult = lastGraveRaw.split(",");
        TranslatableComponent text = Component.translatable((String)"graves.last_grave", (ComponentLike[])new ComponentLike[]{this.insert("x", graveResult[0]), this.insert("y", graveResult[1]), this.insert("z", graveResult[2]), this.insert("world", graveResult[3])});
        player.sendMessage((Component)text);
        return 1;
    }

    private int key(CommandContext<CommandSourceStack> context) {
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        player.getInventory().addItem(new ItemStack[]{TItem.GRAVE_KEY.getItem()});
        player.sendMessage(this.getText("given_key", new ComponentLike[0]));
        return 1;
    }

    private int uninstall(CommandContext<CommandSourceStack> context) {
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (!entity.getScoreboardTags().contains("grave")) continue;
                entity.remove();
            }
        }
        player.sendMessage(this.getText("removed_graves", new ComponentLike[0]));
        return 1;
    }
}

