/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import me.teakivy.teakstweaks.packs.homes.Home;
import me.teakivy.teakstweaks.packs.homes.Homes;
import me.teakivy.teakstweaks.utils.command.AbstractCommand;
import me.teakivy.teakstweaks.utils.permission.Permission;
import me.teakivy.teakstweaks.utils.register.TTCommand;
import net.kyori.adventure.text.ComponentLike;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class HomeCommand
extends AbstractCommand {
    public HomeCommand() {
        super(TTCommand.HOME, "home");
    }

    @Override
    public LiteralCommandNode<CommandSourceStack> getCommand() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"home").requires(this.perm(Permission.COMMAND_HOME))).executes(ctx -> {
            Player player = this.checkPlayer((CommandContext<CommandSourceStack>)ctx);
            if (player == null) {
                return 1;
            }
            this.tpHome(player, "home");
            return 1;
        })).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).suggests(this::homeNameSuggestions).executes(ctx -> {
            Player player = this.checkPlayer((CommandContext<CommandSourceStack>)ctx);
            if (player == null) {
                return 1;
            }
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            this.tpHome(player, name);
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"set").requires(this.perm(Permission.COMMAND_HOME_SET))).executes(ctx -> {
            Player player = this.checkPlayer((CommandContext<CommandSourceStack>)ctx);
            if (player == null) {
                return 1;
            }
            this.setHome(player, "home");
            return 1;
        })).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            Player player = this.checkPlayer((CommandContext<CommandSourceStack>)ctx);
            if (player == null) {
                return 1;
            }
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            this.setHome(player, name);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"delete").requires(this.perm(Permission.COMMAND_HOME_DELETE))).executes(ctx -> {
            Player player = this.checkPlayer((CommandContext<CommandSourceStack>)ctx);
            if (player == null) {
                return 1;
            }
            this.deleteHome(player, "home");
            return 1;
        })).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).suggests(this::homeNameSuggestions).executes(ctx -> {
            Player player = this.checkPlayer((CommandContext<CommandSourceStack>)ctx);
            if (player == null) {
                return 1;
            }
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            this.deleteHome(player, name);
            return 1;
        })))).build();
    }

    public void tpHome(Player player, String name) {
        Home home;
        if (name == null || name.isEmpty()) {
            name = "home";
        }
        if ((home = Homes.getHome(player, name)) == null) {
            player.sendMessage(this.getError("home_dne", this.insert("name", name)));
            return;
        }
        home.teleport();
    }

    public void setHome(Player player, String name) {
        if (name == null || name.isEmpty()) {
            name = "home";
        }
        if (Homes.getHome(player, name) != null) {
            player.sendMessage(this.getError("home_already_exists", this.insert("name", name)));
            return;
        }
        List<Home> homes = Homes.getHomes(player);
        int maxHomes = this.getPackConfig().getInt("max-homes");
        if (maxHomes > 0 && homes.size() >= maxHomes) {
            player.sendMessage(this.getError("max_homes", this.insert("max_homes", maxHomes)));
            return;
        }
        if (!Homes.setHome(player, name, player.getLocation())) {
            player.sendMessage(this.getError("cant_set_home", new ComponentLike[0]));
            return;
        }
        player.sendMessage(this.getText("set_home", this.insert("name", name)));
    }

    public void deleteHome(Player player, String name) {
        Home home;
        if (name == null || name.isEmpty()) {
            name = "home";
        }
        if ((home = Homes.getHome(player, name)) == null) {
            player.sendMessage(this.getError("home_dne", this.insert("name", name)));
            return;
        }
        if (!Homes.removeHome(player, name)) {
            player.sendMessage(this.getError("cant_delete_home", new ComponentLike[0]));
            return;
        }
        player.sendMessage(this.getText("deleted_home", this.insert("name", name)));
    }

    public CompletableFuture<Suggestions> homeNameSuggestions(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        builder.restart();
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        if (!(commandSender instanceof Player)) {
            return builder.buildFuture();
        }
        Player player = (Player)commandSender;
        for (Home home : Homes.getHomes(player)) {
            if (!home.getName().toLowerCase().startsWith(builder.getRemainingLowerCase())) continue;
            builder.suggest(home.getName());
        }
        return builder.buildFuture();
    }
}

