/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.BlockPositionResolver;
import io.papermc.paper.math.BlockPosition;
import me.teakivy.teakstweaks.utils.command.AbstractCommand;
import me.teakivy.teakstweaks.utils.permission.Permission;
import me.teakivy.teakstweaks.utils.register.TTCommand;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class PortalCommand
extends AbstractCommand {
    public PortalCommand() {
        super(TTCommand.PORTAL, "portal");
    }

    @Override
    public LiteralCommandNode<CommandSourceStack> getCommand() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"portal").requires(this.perm(Permission.COMMAND_PORTAL))).executes(this.playerOnly(this::portal))).then(((RequiredArgumentBuilder)Commands.argument((String)"location", (ArgumentType)ArgumentTypes.blockPosition()).requires(this.perm(Permission.COMMAND_PORTAL))).executes(this::portalLoc))).build();
    }

    private int portal(CommandContext<CommandSourceStack> context) {
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        Location location = player.getLocation();
        this.sendLocation(player, location);
        return 1;
    }

    private int portalLoc(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        BlockPositionResolver blockPositionResolver = (BlockPositionResolver)context.getArgument("location", BlockPositionResolver.class);
        BlockPosition blockPosition = (BlockPosition)blockPositionResolver.resolve((CommandSourceStack)context.getSource());
        Location location = blockPosition.toLocation(player.getWorld());
        this.sendLocation(player, location);
        return 1;
    }

    private void sendLocation(Player player, Location location) {
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        if (location.getWorld().getEnvironment() == World.Environment.NORMAL) {
            x /= 8;
            z /= 8;
        } else if (location.getWorld().getEnvironment() == World.Environment.NETHER) {
            x *= 8;
            z *= 8;
        } else {
            player.sendMessage(this.getText("wrong_dimension", this.insert("world", location.getWorld().getName())));
            return;
        }
        player.sendMessage(this.getText("location", this.insert("x", x), this.insert("y", y), this.insert("z", z)));
    }
}

