/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.io.IOException;
import me.teakivy.teakstweaks.packs.thundershrine.ThunderShrine;
import me.teakivy.teakstweaks.utils.command.AbstractCommand;
import me.teakivy.teakstweaks.utils.permission.Permission;
import me.teakivy.teakstweaks.utils.register.TTCommand;
import net.kyori.adventure.text.ComponentLike;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class ShrineCommand
extends AbstractCommand {
    public ShrineCommand() {
        super(TTCommand.SHRINE, "shrine");
    }

    @Override
    public LiteralCommandNode<CommandSourceStack> getCommand() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"shrine").requires(this.perm(Permission.COMMAND_SHRINE))).then(((LiteralArgumentBuilder)Commands.literal((String)"create").requires(this.perm(Permission.COMMAND_SHRINE_CREATE))).executes(this.playerOnly(this::create)))).then(((LiteralArgumentBuilder)Commands.literal((String)"remove").requires(this.perm(Permission.COMMAND_SHRINE_REMOVE))).executes(this.playerOnly(this::remove)))).then(((LiteralArgumentBuilder)Commands.literal((String)"uninstall").requires(this.perm(Permission.COMMAND_SHRINE_UNINSTALL))).executes(this.playerOnly(this::uninstall)))).build();
    }

    private int create(CommandContext<CommandSourceStack> context) {
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        Location loc = player.getLocation();
        String world = loc.getWorld().getName();
        int x = loc.getBlockX();
        int y = loc.getBlockY();
        int z = loc.getBlockZ();
        try {
            ThunderShrine.createShrine(new Location(loc.getWorld(), (double)x, (double)y, (double)z));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        player.sendMessage(this.getText("created", this.insert("x", x), this.insert("y", y), this.insert("z", z), this.insert("world", world)));
        return 1;
    }

    private int remove(CommandContext<CommandSourceStack> context) {
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        Entity shrine = null;
        for (Entity entity : player.getNearbyEntities(3.0, 3.0, 3.0)) {
            if (!ThunderShrine.getShrines().contains(entity)) continue;
            shrine = entity;
        }
        if (shrine == null) {
            player.sendMessage(this.getError("none_nearby", new ComponentLike[0]));
            return 1;
        }
        shrine.remove();
        player.sendMessage(this.getText("removed", this.insert("x", shrine.getLocation().getBlockX()), this.insert("y", shrine.getLocation().getBlockY()), this.insert("z", shrine.getLocation().getBlockZ()), this.insert("world", shrine.getLocation().getWorld().getName())));
        return 1;
    }

    private int uninstall(CommandContext<CommandSourceStack> context) {
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        for (Entity shrine : ThunderShrine.getShrines()) {
            shrine.remove();
        }
        player.sendMessage(this.getText("shrines_mass_removed", new ComponentLike[0]));
        return 1;
    }
}

