/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.Objects;
import me.teakivy.teakstweaks.TeaksTweaks;
import me.teakivy.teakstweaks.packs.back.Back;
import me.teakivy.teakstweaks.utils.ErrorType;
import me.teakivy.teakstweaks.utils.command.AbstractCommand;
import me.teakivy.teakstweaks.utils.permission.Permission;
import me.teakivy.teakstweaks.utils.register.TTCommand;
import net.kyori.adventure.text.ComponentLike;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SpawnCommand
extends AbstractCommand {
    public SpawnCommand() {
        super(TTCommand.SPAWN, "spawn");
        this.setCooldownTime(this.getPackConfig().getInt("teleport-cooldown"));
    }

    @Override
    public LiteralCommandNode<CommandSourceStack> getCommand() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"spawn").requires(this.perm(Permission.COMMAND_SPAWN))).executes(this.playerOnly(this::spawn))).build();
    }

    private int spawn(CommandContext<CommandSourceStack> context) {
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        if (this.isOnCooldown(player)) {
            player.sendMessage(this.getError("on_cooldown", this.insert("time", this.getCooldownTime())));
            return 1;
        }
        this.teleportToSpawn(player);
        this.setCooldown(player);
        return 1;
    }

    private void teleportToSpawn(Player player) {
        World world = Bukkit.getWorld((String)Objects.requireNonNull(this.getPackConfig().getString("world")));
        if (world == null) {
            player.sendMessage(ErrorType.UNKNOWN_ERROR.m());
            return;
        }
        int teleportDelay = this.getPackConfig().getInt("teleport-delay");
        if (teleportDelay <= 0) {
            Back.backLoc.put(player.getUniqueId(), player.getLocation());
            player.teleportAsync(world.getSpawnLocation());
            player.sendMessage(this.getText("teleporting", new ComponentLike[0]));
            return;
        }
        player.sendMessage(this.getText("teleporting_delayed", this.insert("time", teleportDelay)));
        int x = player.getLocation().getBlockX();
        int y = player.getLocation().getBlockY();
        int z = player.getLocation().getBlockZ();
        Bukkit.getScheduler().runTaskLater((Plugin)TeaksTweaks.getInstance(), () -> {
            if (x != player.getLocation().getBlockX() || y != player.getLocation().getBlockY() || z != player.getLocation().getBlockZ()) {
                player.sendMessage(this.getError("teleport_moved", new ComponentLike[0]));
                this.resetCooldown(player);
                return;
            }
            Back.backLoc.put(player.getUniqueId(), player.getLocation());
            player.teleportAsync(world.getSpawnLocation());
            player.sendMessage(this.getText("teleporting", new ComponentLike[0]));
        }, (long)teleportDelay * 20L);
    }
}

