/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.List;
import java.util.function.BiFunction;
import me.teakivy.teakstweaks.packs.spawningspheres.SpawningSpheres;
import me.teakivy.teakstweaks.packs.spawningspheres.SphereType;
import me.teakivy.teakstweaks.utils.ErrorType;
import me.teakivy.teakstweaks.utils.command.AbstractCommand;
import me.teakivy.teakstweaks.utils.permission.Permission;
import me.teakivy.teakstweaks.utils.register.TTCommand;
import org.bukkit.entity.Player;

public class SpawningSpheresCommand
extends AbstractCommand {
    public SpawningSpheresCommand() {
        super(TTCommand.SPAWNINGSPHERES, "spawningspheres", List.of("ss", "sphere"));
    }

    @Override
    public LiteralCommandNode<CommandSourceStack> getCommand() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"spawningspheres").requires(this.perm(Permission.COMMAND_SPAWNINGSPHERES))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"create").requires(this.perm(Permission.COMMAND_SPAWNINGSPHERES_CREATE))).then(Commands.literal((String)"red").executes(this.sPlayerOnly(this::create, SphereType.RED)))).then(Commands.literal((String)"blue").executes(this.sPlayerOnly(this::create, SphereType.BLUE)))).then(Commands.literal((String)"green").executes(this.sPlayerOnly(this::create, SphereType.GREEN))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"remove").requires(this.perm(Permission.COMMAND_SPAWNINGSPHERES_REMOVE))).then(Commands.literal((String)"red").executes(this.sPlayerOnly(this::remove, SphereType.RED)))).then(Commands.literal((String)"blue").executes(this.sPlayerOnly(this::remove, SphereType.BLUE)))).then(Commands.literal((String)"green").executes(this.sPlayerOnly(this::remove, SphereType.GREEN))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"teleport").requires(this.perm(Permission.COMMAND_SPAWNINGSPHERES_TELEPORT))).then(Commands.literal((String)"red").executes(this.sPlayerOnly(this::teleport, SphereType.RED)))).then(Commands.literal((String)"blue").executes(this.sPlayerOnly(this::teleport, SphereType.BLUE)))).then(Commands.literal((String)"green").executes(this.sPlayerOnly(this::teleport, SphereType.GREEN))))).build();
    }

    private int create(CommandContext<CommandSourceStack> context, SphereType type) {
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        boolean success = SpawningSpheres.summonSphere(type, player.getLocation());
        if (!success) {
            player.sendMessage(this.getError("in_use", this.insert("color", type.getName())));
            return 1;
        }
        player.sendMessage(this.getText("summoned", this.insert("color", type.getName())));
        return 1;
    }

    private int remove(CommandContext<CommandSourceStack> context, SphereType type) {
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        boolean success = SpawningSpheres.removeSphere(type, player);
        if (!success) {
            player.sendMessage(this.getError("not_in_use", this.insert("color", type.getName())));
            return 1;
        }
        player.sendMessage(this.getText("removing", this.insert("color", type.getName())));
        return 1;
    }

    private int teleport(CommandContext<CommandSourceStack> context, SphereType type) {
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        boolean success = SpawningSpheres.teleport(type, player);
        if (!success) {
            player.sendMessage(this.getError("not_in_use", this.insert("color", type.getName())));
            return 1;
        }
        player.sendMessage(this.getText("teleporting", this.insert("color", type.getName())));
        return 1;
    }

    private Command<CommandSourceStack> sPlayerOnly(BiFunction<CommandContext<CommandSourceStack>, SphereType, Integer> function, SphereType sphereType) {
        return context -> {
            if (!(((CommandSourceStack)context.getSource()).getSender() instanceof Player)) {
                ((CommandSourceStack)context.getSource()).getSender().sendMessage(ErrorType.NOT_PLAYER.m());
                return 1;
            }
            return (Integer)function.apply(context, sphereType);
        };
    }
}

