/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.PlayerSelectorArgumentResolver;
import java.util.List;
import me.teakivy.teakstweaks.packs.tpa.TPAHandler;
import me.teakivy.teakstweaks.packs.tpa.TPARequest;
import me.teakivy.teakstweaks.utils.ErrorType;
import me.teakivy.teakstweaks.utils.command.AbstractCommand;
import me.teakivy.teakstweaks.utils.permission.Permission;
import me.teakivy.teakstweaks.utils.register.TTCommand;
import net.kyori.adventure.text.ComponentLike;
import org.bukkit.entity.Player;

public class TPAHereCommand
extends AbstractCommand {
    public TPAHereCommand() {
        super(TTCommand.TPAHERE, "tpahere");
    }

    @Override
    public LiteralCommandNode<CommandSourceStack> getCommand() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tpahere").requires(this.perm(Permission.COMMAND_TPA))).then(Commands.argument((String)"target", (ArgumentType)ArgumentTypes.player()).executes(this.playerOnly(this::tpahere)))).then(Commands.literal((String)"accept").then(Commands.argument((String)"target", (ArgumentType)ArgumentTypes.player()).executes(this.playerOnly(this::accept))))).then(Commands.literal((String)"cancel").executes(this.playerOnly(this::cancel)))).build();
    }

    private int tpahere(CommandContext<CommandSourceStack> context) {
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        PlayerSelectorArgumentResolver targetResolver = (PlayerSelectorArgumentResolver)context.getArgument("target", PlayerSelectorArgumentResolver.class);
        try {
            Player target = (Player)((List)targetResolver.resolve((CommandSourceStack)context.getSource())).getFirst();
            if (target == null) {
                player.sendMessage(ErrorType.PLAYER_DNE.m());
                return 1;
            }
            if (TPAHandler.hasOutgoingRequest(player)) {
                player.sendMessage(this.getError("has_outgoing_request", new ComponentLike[0]));
                return 1;
            }
            TPARequest request = new TPARequest(player, target, TPARequest.TPAType.TPAHERE);
            TPAHandler.sendRequest(request);
            return 1;
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private int accept(CommandContext<CommandSourceStack> context) {
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        PlayerSelectorArgumentResolver targetResolver = (PlayerSelectorArgumentResolver)context.getArgument("target", PlayerSelectorArgumentResolver.class);
        try {
            Player target = (Player)((List)targetResolver.resolve((CommandSourceStack)context.getSource())).getFirst();
            if (target == null) {
                player.sendMessage(ErrorType.PLAYER_DNE.m());
                return 1;
            }
            TPARequest request = TPAHandler.getRequest(target, player);
            if (request == null) {
                player.sendMessage(this.getError("no_pending_requests", new ComponentLike[0]));
                return 1;
            }
            TPAHandler.acceptRequest(request);
            return 1;
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private int cancel(CommandContext<CommandSourceStack> context) {
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        TPARequest request = TPAHandler.getOutgoingRequest(player);
        if (request == null) {
            player.sendMessage(this.getError("no_outgoing_request", new ComponentLike[0]));
            return 1;
        }
        TPAHandler.cancelRequest(request);
        return 1;
    }
}

