/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.PlayerSelectorArgumentResolver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import me.teakivy.teakstweaks.utils.ErrorType;
import me.teakivy.teakstweaks.utils.URLUtils;
import me.teakivy.teakstweaks.utils.Wiki;
import me.teakivy.teakstweaks.utils.command.AbstractCommand;
import me.teakivy.teakstweaks.utils.config.Config;
import me.teakivy.teakstweaks.utils.customitems.ItemHandler;
import me.teakivy.teakstweaks.utils.log.PasteManager;
import me.teakivy.teakstweaks.utils.log.PasteUploader;
import me.teakivy.teakstweaks.utils.permission.Permission;
import me.teakivy.teakstweaks.utils.register.TTCommand;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class TeaksTweaksCommand
extends AbstractCommand {
    public TeaksTweaksCommand() {
        super(TTCommand.TEAKSTWEAKS, "teakstweakscommand", List.of("tt", "tweaks"));
    }

    @Override
    public LiteralCommandNode<CommandSourceStack> getCommand() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"teakstweaks").executes(this::info)).then(Commands.literal((String)"info").executes(this::info))).then(Commands.literal((String)"version").executes(this::version))).then(Commands.literal((String)"support").executes(this::support))).then(Commands.literal((String)"update").executes(this::update))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"wiki").then(Commands.literal((String)"packs").executes(ctx -> this.wiki((CommandContext<CommandSourceStack>)ctx, "Packs")))).then(Commands.literal((String)"craftingtweaks").executes(ctx -> this.wiki((CommandContext<CommandSourceStack>)ctx, "Crafting-Tweaks")))).then(Commands.literal((String)"commands").executes(ctx -> this.wiki((CommandContext<CommandSourceStack>)ctx, "Commands"))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"paste").requires(this.perm(Permission.COMMAND_TEAKSTWEAKS_PASTE))).then(Commands.argument((String)"include logs", (ArgumentType)BoolArgumentType.bool()).executes(this::paste))).executes(ctx -> this.paste((CommandContext<CommandSourceStack>)ctx, Config.getBoolean("settings.send-log-in-paste"))))).then(((LiteralArgumentBuilder)Commands.literal((String)"give").requires(this.perm(Permission.COMMAND_TEAKSTWEAKS_GIVE))).then(Commands.argument((String)"targets", (ArgumentType)ArgumentTypes.players()).then(Commands.argument((String)"item", (ArgumentType)StringArgumentType.word()).suggests(this::getGiveItemSuggestions).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)2304)).executes(this::give)))))).build();
    }

    private int info(CommandContext<CommandSourceStack> ctx) {
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        ArrayList<Object> components = new ArrayList<Object>();
        components.add(this.getText("info.dashed_line", new ComponentLike[0]));
        components.add(Component.empty());
        components.add(this.getText("info.title", this.insert("version", this.getPlugin().getDescription().getVersion())));
        components.add(Component.empty());
        components.add(this.getText("info.author", this.insert("author", this.get("plugin.author", new ComponentLike[0]))));
        components.add(this.getText("info.config_version", this.insert("config_version", Config.getVersion())));
        components.add(this.getText("info.config_generated", this.insert("config_generated", Config.getCreatedVersion())));
        if (Config.isDevMode()) {
            components.add(this.getText("info.dev_mode_enabled", new ComponentLike[0]));
        }
        components.add(this.getText("info.support", this.insert("discord", URLUtils.clickable(URLUtils.getDiscord()))));
        components.add(Component.empty());
        components.add(this.getText("info.dashed_line", new ComponentLike[0]));
        for (Component component : components) {
            sender.sendMessage(component);
        }
        return 1;
    }

    private int version(CommandContext<CommandSourceStack> ctx) {
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        sender.sendMessage(this.getText("version", this.insert("version", this.getPlugin().getDescription().getVersion())));
        return 1;
    }

    private int support(CommandContext<CommandSourceStack> ctx) {
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        sender.sendMessage(this.getText("support", this.insert("discord", URLUtils.clickable(URLUtils.getDiscord()))));
        return 1;
    }

    private int update(CommandContext<CommandSourceStack> ctx) {
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        sender.sendMessage(this.getText("update", this.insert("url", URLUtils.clickable(URLUtils.getModrinth()))));
        return 1;
    }

    private int wiki(CommandContext<CommandSourceStack> ctx, String page) {
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        sender.sendMessage(this.getText("wiki", this.insert("wiki", URLUtils.clickable(Wiki.getWikiPage(page)))));
        return 1;
    }

    private int paste(CommandContext<CommandSourceStack> ctx) {
        return this.paste(ctx, (Boolean)ctx.getArgument("include logs", Boolean.TYPE));
    }

    private int paste(CommandContext<CommandSourceStack> ctx, boolean logs) {
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        sender.sendMessage(this.getText("paste.uploading", this.insert("service_name", "Pastebin")));
        String playerName = sender instanceof Player ? sender.getName() : "CONSOLE";
        String paste = PasteManager.getPasteContent(playerName, logs);
        try {
            String url = PasteUploader.uploadToPastebin(paste, "Support: " + playerName);
            if (sender instanceof Player) {
                sender.sendMessage(this.getText("paste.success", this.insert("url", URLUtils.clickable(url)), this.insert("service_name", "Pastebin")));
                return 1;
            }
            sender.sendMessage(this.getText("paste.success.console", this.insert("url", url), this.insert("service_name", "Pastebin")));
            return 1;
        }
        catch (IOException e) {
            sender.sendMessage(this.getText("paste.error", this.insert("service_name", "Pastebin")));
            e.printStackTrace();
            return 0;
        }
    }

    private CompletableFuture<Suggestions> getGiveItemSuggestions(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        builder.restart();
        for (String key : ItemHandler.getAllKeys()) {
            if (!key.toLowerCase().startsWith(builder.getRemainingLowerCase())) continue;
            builder.suggest(key);
        }
        return builder.buildFuture();
    }

    private int give(CommandContext<CommandSourceStack> ctx) {
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        PlayerSelectorArgumentResolver targetResolver = (PlayerSelectorArgumentResolver)ctx.getArgument("targets", PlayerSelectorArgumentResolver.class);
        try {
            List targets = (List)targetResolver.resolve((CommandSourceStack)ctx.getSource());
            String itemName = (String)ctx.getArgument("item", String.class);
            int amount = (Integer)ctx.getArgument("amount", Integer.class);
            ItemStack item = ItemHandler.getItem(itemName);
            if (item == null) {
                sender.sendMessage(this.getError("give.unknown_item", this.insert("item", ctx.getArgument("item", String.class))));
                return 0;
            }
            for (Player target : targets) {
                ItemStack giveItem = item.clone();
                for (int i = 0; i < amount; ++i) {
                    target.give(new ItemStack[]{giveItem});
                }
            }
            TextComponent recipient = targets.size() == 1 ? Component.text((String)((Player)targets.getFirst()).getName()) : this.getText("teakstweakscommand.give.all_players", new ComponentLike[0]);
            sender.sendMessage(this.getText("give.success", this.insert("amount", amount), this.insert("item", itemName), this.insert("player", (Component)recipient)));
            return 1;
        }
        catch (CommandSyntaxException e) {
            sender.sendMessage(ErrorType.UNKNOWN_ERROR.m());
            throw new RuntimeException(e);
        }
    }
}

