/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import me.teakivy.teakstweaks.packs.workstationhighlights.WorkstationHighlights;
import me.teakivy.teakstweaks.utils.command.AbstractCommand;
import me.teakivy.teakstweaks.utils.permission.Permission;
import me.teakivy.teakstweaks.utils.register.TTCommand;
import net.kyori.adventure.text.ComponentLike;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.entity.memory.MemoryKey;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class WorkstationHighlightCommand
extends AbstractCommand {
    private static final String[] professionTypes = new String[]{"any", "armorer", "butcher", "cartographer", "cleric", "farmer", "fisherman", "fletcher", "leatherworker", "librarian", "mason", "shepherd", "toolsmith", "weaponsmith"};

    public WorkstationHighlightCommand() {
        super(TTCommand.WORKSTATIONHIGHLIGHT, "workstationhighlight");
    }

    @Override
    public LiteralCommandNode<CommandSourceStack> getCommand() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"workstationhighlight").requires(this.perm(Permission.COMMAND_SUDOKU))).executes(ctx -> {
            Player player = this.checkPlayer((CommandContext<CommandSourceStack>)ctx);
            if (player == null) {
                return 1;
            }
            this.highlight(player, "any", 8);
            return 1;
        })).then(((RequiredArgumentBuilder)Commands.argument((String)"profession", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            Player player = this.checkPlayer((CommandContext<CommandSourceStack>)ctx);
            if (player == null) {
                return 1;
            }
            String profession = (String)ctx.getArgument("profession", String.class);
            if (!Arrays.toString(professionTypes).contains(profession)) {
                player.sendMessage(this.getError("invalid_profession", new ComponentLike[0]));
                return 1;
            }
            this.highlight(player, profession, 8);
            return 1;
        })).suggests(this::professionSuggestions).then(Commands.argument((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)16)).executes(ctx -> {
            Player player = this.checkPlayer((CommandContext<CommandSourceStack>)ctx);
            if (player == null) {
                return 1;
            }
            String profession = (String)ctx.getArgument("profession", String.class);
            if (!Arrays.toString(professionTypes).contains(profession)) {
                player.sendMessage(this.getError("invalid_profession", new ComponentLike[0]));
                return 1;
            }
            int radius = (Integer)ctx.getArgument("radius", Integer.class);
            this.highlight(player, profession, radius);
            return 1;
        })))).then(Commands.literal((String)"clear").executes(this::clear))).build();
    }

    private void highlight(Player player, String profession, int radius) {
        Entity entity = null;
        double distance = 2.147483647E9;
        for (Entity e : player.getNearbyEntities((double)radius, (double)radius, (double)radius)) {
            double d;
            Villager villager;
            if (e.getType() != EntityType.VILLAGER || (villager = (Villager)e).getProfession() == Villager.Profession.NONE || villager.getProfession() == Villager.Profession.NITWIT || !profession.equals("any") && !villager.getProfession().toString().toLowerCase().equals(profession) || !((d = e.getLocation().distanceSquared(player.getLocation())) < distance)) continue;
            entity = e;
            distance = d;
        }
        if (entity == null) {
            player.sendMessage(this.getError("no_workstations_found", new ComponentLike[0]));
            return;
        }
        Villager villager = (Villager)entity;
        Location jobSite = (Location)villager.getMemory(MemoryKey.JOB_SITE);
        if (jobSite == null) {
            player.sendMessage(this.getError("no_job_site", new ComponentLike[0]));
            return;
        }
        villager.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, 200, 0, false, false, false));
        WorkstationHighlights.glowingBlock(jobSite, 200);
        this.createParticles(jobSite.add(0.5, 1.0, 0.5));
        player.sendMessage(this.getText("found", this.insert("x", jobSite.getBlockX()), this.insert("y", jobSite.getBlockY()), this.insert("z", jobSite.getBlockZ())));
    }

    private int clear(CommandContext<CommandSourceStack> context) {
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        WorkstationHighlights.clear();
        player.sendMessage(this.getText("cleared", new ComponentLike[0]));
        return 1;
    }

    private void createParticles(Location location) {
        AreaEffectCloud e = (AreaEffectCloud)location.getWorld().spawnEntity(location, EntityType.AREA_EFFECT_CLOUD);
        e.setParticle(Particle.HEART);
        e.setRadius(0.001f);
        e.setRadiusPerTick(0.0f);
        e.setRadiusOnUse(0.0f);
        e.setDuration(200);
        e.setWaitTime(10);
    }

    public CompletableFuture<Suggestions> professionSuggestions(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        builder.restart();
        String[] stringArray = ((CommandSourceStack)ctx.getSource()).getSender();
        if (!(stringArray instanceof Player)) {
            return builder.buildFuture();
        }
        Player player = (Player)stringArray;
        for (String profession : professionTypes) {
            if (!profession.toLowerCase().startsWith(builder.getRemainingLowerCase())) continue;
            builder.suggest(profession);
        }
        return builder.buildFuture();
    }
}

