/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.craftingtweaks;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import me.teakivy.teakstweaks.TeaksTweaks;
import me.teakivy.teakstweaks.utils.config.Config;
import me.teakivy.teakstweaks.utils.lang.TranslationManager;
import me.teakivy.teakstweaks.utils.log.Logger;
import me.teakivy.teakstweaks.utils.metrics.CustomMetrics;
import me.teakivy.teakstweaks.utils.recipe.RecipeManager;
import me.teakivy.teakstweaks.utils.register.TTCraftingTweak;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class AbstractCraftingTweak {
    private final String name;
    private final String path;
    private final TTCraftingTweak craftingTweak;
    private final Material material;
    private final String description;
    private ItemStack item;

    public AbstractCraftingTweak(TTCraftingTweak craftingTweak, Material material) {
        this.craftingTweak = craftingTweak;
        this.path = craftingTweak.getKey();
        String langKey = this.path.replaceAll("-", "_");
        this.name = TranslationManager.getString(Config.getLanguage(), langKey + ".name");
        this.material = material;
        this.description = TranslationManager.getString(Config.getLanguage(), langKey + ".description");
    }

    /*
     * WARNING - void declaration
     */
    public void init() {
        void var5_7;
        Logger.info((Component)Component.text((String)TranslationManager.getString(Config.getLanguage(), "startup.register.crafting_tweak").replace("\\<name>", this.name)));
        TeaksTweaks.getInstance().addCraftingTweaks(this.name);
        this.registerRecipes();
        this.item = new ItemStack(this.material);
        ArrayList<CallSite> lore = new ArrayList<CallSite>();
        StringBuilder newLine = new StringBuilder();
        String[] stringArray = this.description.split(" ");
        int n = stringArray.length;
        boolean bl = false;
        while (var5_7 < n) {
            String word = stringArray[var5_7];
            if (newLine.length() > 30) {
                lore.add((CallSite)((Object)("<gray>" + String.valueOf(newLine))));
                newLine = new StringBuilder();
            }
            newLine.append(word).append(" ");
            ++var5_7;
        }
        lore.add((CallSite)((Object)("<gray>" + String.valueOf(newLine))));
        ArrayList<Component> components = new ArrayList<Component>();
        for (String string : lore) {
            components.add(MiniMessage.miniMessage().deserialize((Object)string).decoration(TextDecoration.ITALIC, false));
        }
        ItemMeta meta = this.item.getItemMeta();
        meta.lore(components);
        meta.displayName(MiniMessage.miniMessage().deserialize((Object)("<gold>" + this.name)).decoration(TextDecoration.ITALIC, false));
        this.item.setItemMeta(meta);
        CustomMetrics.addCraftingTweakEnabled(this.name);
    }

    public void register() {
        if (Config.isCraftingTweakEnabled(this.path) || Config.isDevMode()) {
            this.init();
        }
    }

    public void unregister() {
        RecipeManager.unregister(this.path);
    }

    public abstract void registerRecipes();

    public void addRecipe(Recipe recipe) {
        RecipeManager.register(this.path, recipe);
    }

    public ItemStack getItem() {
        return this.item;
    }

    public TTCraftingTweak getCraftingTweak() {
        return this.craftingTweak;
    }
}

