/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs;

import java.util.ArrayList;
import java.util.List;
import me.teakivy.teakstweaks.TeaksTweaks;
import me.teakivy.teakstweaks.utils.config.Config;
import me.teakivy.teakstweaks.utils.customitems.CustomItem;
import me.teakivy.teakstweaks.utils.lang.TranslationManager;
import me.teakivy.teakstweaks.utils.log.Logger;
import me.teakivy.teakstweaks.utils.metrics.CustomMetrics;
import me.teakivy.teakstweaks.utils.recipe.RecipeManager;
import me.teakivy.teakstweaks.utils.register.TTPack;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.translation.Argument;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.intellij.lang.annotations.Subst;

public class BasePack
implements Listener {
    private final String name;
    private final String path;
    private final String translatableKey;
    private final ItemStack item;
    private final TTPack pack;
    private boolean registered = false;

    /*
     * WARNING - void declaration
     */
    public BasePack(TTPack pack, Material material) {
        void var7_10;
        this.pack = pack;
        this.path = pack.getKey();
        this.translatableKey = this.path.replaceAll("-", "_");
        this.name = TranslationManager.getString(Config.getLanguage(), this.translatableKey + ".name");
        String[] description = TranslationManager.getString(Config.getLanguage(), this.translatableKey + ".description").split("<newline>");
        this.item = new ItemStack(material);
        ArrayList<Object> lore = new ArrayList<Object>();
        String[] stringArray = description;
        int n = stringArray.length;
        boolean bl = false;
        while (var7_10 < n) {
            String line = stringArray[var7_10];
            StringBuilder newLine = new StringBuilder();
            for (String word : line.split(" ")) {
                if (newLine.length() > 30) {
                    lore.add("<gray>" + String.valueOf(newLine));
                    newLine = new StringBuilder();
                }
                newLine.append(word).append(" ");
            }
            lore.add("<gray>" + String.valueOf(newLine));
            lore.add(" ");
            ++var7_10;
        }
        if (!lore.isEmpty()) {
            lore.removeLast();
        }
        if (this.getConfig().getKeys(false).size() > 1) {
            lore.add(" ");
            lore.add("<gold>Config");
        }
        for (String key : this.getConfig().getKeys(false)) {
            if (key.equals("enabled") || this.getConfig().get(key).toString().startsWith("MemorySection")) continue;
            if (this.getConfig().isList(key) && this.getConfig().getList(key).size() > 3) {
                lore.add("  <gray>" + this.transformKey(key) + ": <reset><gold><italic>[" + this.getConfig().getList(key).size() + " Items]");
                continue;
            }
            lore.add("  <gray>" + this.transformKey(key) + ": <reset><gold>" + String.valueOf(this.getConfig().get(key)));
        }
        ArrayList<Component> loreComponents = new ArrayList<Component>();
        for (String string : lore) {
            loreComponents.add(MiniMessage.miniMessage().deserialize((Object)("<reset>" + string)).decoration(TextDecoration.ITALIC, false));
        }
        ItemMeta meta = this.item.getItemMeta();
        meta.lore(loreComponents);
        meta.displayName(MiniMessage.miniMessage().deserialize((Object)("<gold>" + this.name)).decoration(TextDecoration.ITALIC, false));
        this.item.setItemMeta(meta);
    }

    public void init() {
        if (this.registered) {
            return;
        }
        this.registered = true;
        this.registerEvents(this);
        List<CustomItem> customItems = this.registerItems();
        if (customItems != null) {
            for (CustomItem customItem : customItems) {
                customItem.register();
            }
        }
        this.getPlugin().addPack(this.name);
        Logger.info((Component)Component.text((String)TranslationManager.getString(Config.getLanguage(), "startup.register.pack").replace("\\<name>", this.name)));
        CustomMetrics.addPackEnabled(this.name);
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public TTPack getPack() {
        return this.pack;
    }

    public List<CustomItem> registerItems() {
        return new ArrayList<CustomItem>();
    }

    public void registerEvents(Listener listener) {
        HandlerList.unregisterAll((Listener)listener);
        Bukkit.getServer().getPluginManager().registerEvents(listener, (Plugin)this.getPlugin());
    }

    public void unregister() {
        HandlerList.unregisterAll((Listener)this);
        RecipeManager.unregister(this.path);
    }

    public String getName() {
        return this.name;
    }

    public TeaksTweaks getPlugin() {
        return TeaksTweaks.getInstance();
    }

    public String getPath() {
        return this.path;
    }

    public ConfigurationSection getConfig() {
        return Config.getPackConfig(this.path);
    }

    public void addRecipe(Recipe recipe) {
        RecipeManager.register(this.path, recipe);
    }

    public ItemStack getItem() {
        return this.item;
    }

    private String transformKey(String key) {
        String[] words = key.split("-");
        StringBuilder newKey = new StringBuilder();
        for (String word : words) {
            if (word.equals("xp")) {
                newKey.append("XP");
                continue;
            }
            newKey.append(word.substring(0, 1).toUpperCase()).append(word.substring(1).toLowerCase()).append(" ");
        }
        return newKey.toString().trim();
    }

    protected String getString(String key) {
        return TranslationManager.getString(Config.getLanguage(), this.translatableKey + "." + key);
    }

    protected Component getText(String key, ComponentLike ... resolvers) {
        return Component.translatable((String)(this.translatableKey + "." + key), (ComponentLike[])resolvers);
    }

    public static ComponentLike insert(@Subst(value="") String key, Object value) {
        return Argument.component((String)key, (ComponentLike)Component.text((String)value.toString()));
    }

    public ComponentLike insert(@Subst(value="") String key, Component value) {
        return Argument.component((String)key, (ComponentLike)value);
    }

    public static Component newText(String text, TagResolver ... resolvers) {
        return MiniMessage.miniMessage().deserialize(text, resolvers);
    }
}

