/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.cauldroncopper;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;

public class CopperAgeTier {
    private final Material base;
    private final Material exposed;
    private final Material weathered;
    private final Material oxidized;

    public CopperAgeTier(Material base, Material exposed, Material weathered, Material oxidized) {
        this.base = base;
        this.exposed = exposed;
        this.weathered = weathered;
        this.oxidized = oxidized;
    }

    public boolean contains(Material material) {
        return material == this.base || material == this.exposed || material == this.weathered || material == this.oxidized;
    }

    public Material getNextStage(Material material) {
        if (material == this.base) {
            return this.exposed;
        }
        if (material == this.exposed) {
            return this.weathered;
        }
        if (material == this.weathered) {
            return this.oxidized;
        }
        return null;
    }

    public boolean hasNextStage(Material material) {
        return material == this.base || material == this.exposed || material == this.weathered;
    }

    public CopperAgeTier getWaxedVariant() {
        return new CopperAgeTier(this.getWaxed(this.base), this.getWaxed(this.exposed), this.getWaxed(this.weathered), this.getWaxed(this.oxidized));
    }

    private Material getWaxed(Material type) {
        if (type == null) {
            return null;
        }
        return Material.getMaterial((String)("WAXED_" + type.name()));
    }

    public static List<CopperAgeTier> getTiers() {
        ArrayList<CopperAgeTier> tiers = new ArrayList<CopperAgeTier>();
        tiers.add(new CopperAgeTier(Material.COPPER_BLOCK, Material.EXPOSED_COPPER, Material.WEATHERED_COPPER, Material.OXIDIZED_COPPER));
        tiers.add(new CopperAgeTier(Material.CHISELED_COPPER, Material.EXPOSED_CHISELED_COPPER, Material.WEATHERED_CHISELED_COPPER, Material.OXIDIZED_CHISELED_COPPER));
        tiers.add(new CopperAgeTier(Material.COPPER_GRATE, Material.EXPOSED_COPPER_GRATE, Material.WEATHERED_COPPER_GRATE, Material.OXIDIZED_COPPER_GRATE));
        tiers.add(new CopperAgeTier(Material.CUT_COPPER, Material.EXPOSED_CUT_COPPER, Material.WEATHERED_CUT_COPPER, Material.OXIDIZED_CUT_COPPER));
        tiers.add(new CopperAgeTier(Material.CUT_COPPER_STAIRS, Material.EXPOSED_CUT_COPPER_STAIRS, Material.WEATHERED_CUT_COPPER_STAIRS, Material.OXIDIZED_CUT_COPPER_STAIRS));
        tiers.add(new CopperAgeTier(Material.CUT_COPPER_SLAB, Material.EXPOSED_CUT_COPPER_SLAB, Material.WEATHERED_CUT_COPPER_SLAB, Material.OXIDIZED_CUT_COPPER_SLAB));
        tiers.add(new CopperAgeTier(Material.COPPER_DOOR, Material.EXPOSED_COPPER_DOOR, Material.WEATHERED_COPPER_DOOR, Material.OXIDIZED_COPPER_DOOR));
        tiers.add(new CopperAgeTier(Material.COPPER_TRAPDOOR, Material.EXPOSED_COPPER_TRAPDOOR, Material.WEATHERED_COPPER_TRAPDOOR, Material.OXIDIZED_COPPER_TRAPDOOR));
        tiers.add(new CopperAgeTier(Material.COPPER_BULB, Material.EXPOSED_COPPER_BULB, Material.WEATHERED_COPPER_BULB, Material.OXIDIZED_COPPER_BULB));
        tiers.add(new CopperAgeTier(Material.COPPER_BARS, Material.EXPOSED_COPPER_BARS, Material.WEATHERED_COPPER_BARS, Material.OXIDIZED_COPPER_BARS));
        tiers.add(new CopperAgeTier(Material.COPPER_CHAIN, Material.EXPOSED_COPPER_CHAIN, Material.WEATHERED_COPPER_CHAIN, Material.OXIDIZED_COPPER_CHAIN));
        tiers.add(new CopperAgeTier(Material.COPPER_LANTERN, Material.EXPOSED_COPPER_LANTERN, Material.WEATHERED_COPPER_LANTERN, Material.OXIDIZED_COPPER_LANTERN));
        tiers.add(new CopperAgeTier(Material.COPPER_CHEST, Material.EXPOSED_COPPER_CHEST, Material.WEATHERED_COPPER_CHEST, Material.OXIDIZED_COPPER_CHEST));
        tiers.add(new CopperAgeTier(Material.COPPER_GOLEM_STATUE, Material.EXPOSED_COPPER_GOLEM_STATUE, Material.WEATHERED_COPPER_GOLEM_STATUE, Material.OXIDIZED_COPPER_GOLEM_STATUE));
        int size = tiers.size();
        for (int i = 0; i < size; ++i) {
            tiers.add(((CopperAgeTier)tiers.get(i)).getWaxedVariant());
        }
        return tiers;
    }
}

