/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.cauldroncopper;

import java.util.UUID;
import me.teakivy.teakstweaks.utils.Key;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Marker;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.util.Transformation;

public class CustomCopperCauldron {
    private Location location;
    private int level;
    private Material type;
    private UUID markerId;
    private UUID overlayId;

    public CustomCopperCauldron(Location location, int level, Material type) {
        this.location = location.getBlock().getLocation();
        this.level = level;
        this.type = type;
        Marker marker = (Marker)location.getWorld().spawn(location.getBlock().getLocation(), Marker.class);
        this.markerId = marker.getUniqueId();
        PersistentDataContainer markerData = marker.getPersistentDataContainer();
        markerData.set(Key.get("custom_cauldron"), PersistentDataType.BOOLEAN, (Object)true);
        markerData.set(Key.get("cauldron_level"), PersistentDataType.INTEGER, (Object)level);
        markerData.set(Key.get("cauldron_type"), PersistentDataType.STRING, (Object)type.name());
        BlockDisplay overlay = (BlockDisplay)location.getWorld().spawn(location.getBlock().getLocation().add(0.125, 0.25, 0.125), BlockDisplay.class, display -> {
            display.setBlock(type.createBlockData());
            Transformation transformation = display.getTransformation();
            transformation.getScale().set(0.75f, (float)(2 + level * 3) / 16.0f, 0.75f);
            display.setTransformation(transformation);
        });
        this.overlayId = overlay.getUniqueId();
        markerData.set(Key.get("cauldron_overlay"), PersistentDataType.STRING, (Object)this.overlayId.toString());
    }

    public CustomCopperCauldron(Location location, int level, Material type, UUID markerId, UUID overlayId) {
        this.location = location.getBlock().getLocation();
        this.level = level;
        this.type = type;
        this.markerId = markerId;
        this.overlayId = overlayId;
    }

    public boolean setLevel(int level) {
        if (level > 3) {
            return false;
        }
        if (level <= 0) {
            BlockDisplay overlay;
            Marker marker = (Marker)this.location.getWorld().getEntity(this.markerId);
            if (marker != null) {
                marker.remove();
            }
            if ((overlay = (BlockDisplay)this.location.getWorld().getEntity(this.overlayId)) != null) {
                overlay.remove();
            }
            return true;
        }
        this.level = level;
        Marker marker = (Marker)this.location.getWorld().getEntity(this.markerId);
        if (marker == null) {
            return false;
        }
        PersistentDataContainer markerData = marker.getPersistentDataContainer();
        markerData.set(Key.get("cauldron_level"), PersistentDataType.INTEGER, (Object)level);
        BlockDisplay overlay = (BlockDisplay)this.location.getWorld().getEntity(this.overlayId);
        if (overlay == null) {
            return false;
        }
        Transformation transformation = overlay.getTransformation();
        transformation.getScale().set(0.75f, (float)(2 + level * 3) / 16.0f, 0.75f);
        overlay.setTransformation(transformation);
        return true;
    }

    public boolean remove() {
        return this.setLevel(0);
    }

    public static CustomCopperCauldron fromMarker(Marker marker) {
        PersistentDataContainer data = marker.getPersistentDataContainer();
        if (!data.has(Key.get("custom_cauldron"), PersistentDataType.BOOLEAN)) {
            return null;
        }
        int level = (Integer)data.get(Key.get("cauldron_level"), PersistentDataType.INTEGER);
        String typeString = (String)data.get(Key.get("cauldron_type"), PersistentDataType.STRING);
        if (typeString == null) {
            return null;
        }
        Material type = Material.getMaterial((String)typeString);
        return new CustomCopperCauldron(marker.getLocation(), level, type, marker.getUniqueId(), UUID.fromString((String)data.get(Key.get("cauldron_overlay"), PersistentDataType.STRING)));
    }

    public static CustomCopperCauldron getCauldronAt(Location location) {
        for (Marker marker : location.getWorld().getEntitiesByClass(Marker.class)) {
            PersistentDataContainer data = marker.getPersistentDataContainer();
            if (!data.has(Key.get("custom_cauldron"), PersistentDataType.BOOLEAN) || !marker.getLocation().getBlock().equals((Object)location.getBlock())) continue;
            return CustomCopperCauldron.fromMarker(marker);
        }
        return null;
    }

    public boolean move(Location location) {
        this.location = location.getBlock().getLocation();
        Marker marker = (Marker)location.getWorld().getEntity(this.markerId);
        if (marker == null) {
            return false;
        }
        marker.teleport(location.getBlock().getLocation());
        BlockDisplay overlay = (BlockDisplay)location.getWorld().getEntity(this.overlayId);
        if (overlay == null) {
            return false;
        }
        overlay.teleport(location.getBlock().getLocation().add(0.125, 0.25, 0.125));
        return true;
    }

    public Location getLocation() {
        return this.location;
    }

    public int getLevel() {
        return this.level;
    }

    public Material getType() {
        return this.type;
    }

    public UUID getMarkerId() {
        return this.markerId;
    }

    public boolean isFull() {
        return this.level >= 3;
    }

    public void addLevel() {
        this.setLevel(this.level + 1);
    }

    public void removeLevel() {
        this.setLevel(this.level - 1);
    }
}

