/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.cauldronpotions;

import java.util.UUID;
import me.teakivy.teakstweaks.utils.Key;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.entity.Marker;
import org.bukkit.entity.TextDisplay;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionType;
import org.bukkit.util.Transformation;
import org.bukkit.util.Vector;

public class PotionCauldron {
    private Location location;
    private int level;
    private PotionType type;
    private UUID markerId;
    private UUID overlayId;

    public PotionCauldron(Location location, int level, PotionType type) {
        this.location = location.getBlock().getLocation();
        this.level = level;
        this.type = type;
        Marker marker = (Marker)location.getWorld().spawn(location.getBlock().getLocation(), Marker.class);
        this.markerId = marker.getUniqueId();
        PersistentDataContainer markerData = marker.getPersistentDataContainer();
        markerData.set(Key.get("potion_cauldron"), PersistentDataType.BOOLEAN, (Object)true);
        markerData.set(Key.get("potion_cauldron_level"), PersistentDataType.INTEGER, (Object)level);
        markerData.set(Key.get("potion_cauldron_type"), PersistentDataType.STRING, (Object)type.name());
        TextDisplay overlay = (TextDisplay)location.getWorld().spawn(location.getBlock().getLocation().add(this.getOffset(level)), TextDisplay.class, display -> {
            display.text((Component)Component.text((String)" "));
            display.setTextOpacity((byte)0);
            display.setBackgroundColor(((PotionEffect)type.getPotionEffects().getFirst()).getType().getColor().setAlpha(150));
            display.setDefaultBackground(false);
            display.setRotation(0.0f, -90.0f);
            Transformation transformation = display.getTransformation();
            transformation.getScale().set(6.8, 3.9, 1.0);
            display.setTransformation(transformation);
        });
        this.overlayId = overlay.getUniqueId();
        markerData.set(Key.get("potion_cauldron_overlay"), PersistentDataType.STRING, (Object)this.overlayId.toString());
    }

    public PotionCauldron(Location location, int level, PotionType type, UUID markerId, UUID overlayId) {
        this.location = location.getBlock().getLocation();
        this.level = level;
        this.type = type;
        this.markerId = markerId;
        this.overlayId = overlayId;
    }

    public boolean setLevel(int level) {
        if (level > 3) {
            return false;
        }
        if (level <= 0) {
            TextDisplay overlay;
            Marker marker = (Marker)this.location.getWorld().getEntity(this.markerId);
            if (marker != null) {
                marker.remove();
            }
            if ((overlay = (TextDisplay)this.location.getWorld().getEntity(this.overlayId)) != null) {
                overlay.remove();
            }
            return true;
        }
        this.level = level;
        Marker marker = (Marker)this.location.getWorld().getEntity(this.markerId);
        if (marker == null) {
            return false;
        }
        PersistentDataContainer markerData = marker.getPersistentDataContainer();
        markerData.set(Key.get("potion_cauldron_level"), PersistentDataType.INTEGER, (Object)level);
        TextDisplay overlay = (TextDisplay)this.location.getWorld().getEntity(this.overlayId);
        if (overlay == null) {
            return false;
        }
        overlay.teleport(this.location.getBlock().getLocation().add(this.getOffset(level)));
        overlay.setRotation(0.0f, -90.0f);
        return true;
    }

    public boolean remove() {
        return this.setLevel(0);
    }

    public static PotionCauldron fromMarker(Marker marker) {
        PersistentDataContainer data = marker.getPersistentDataContainer();
        if (!data.has(Key.get("potion_cauldron"), PersistentDataType.BOOLEAN)) {
            return null;
        }
        int level = (Integer)data.get(Key.get("potion_cauldron_level"), PersistentDataType.INTEGER);
        String typeString = (String)data.get(Key.get("potion_cauldron_type"), PersistentDataType.STRING);
        if (typeString == null) {
            return null;
        }
        PotionType type = PotionType.valueOf((String)typeString);
        return new PotionCauldron(marker.getLocation(), level, type, marker.getUniqueId(), UUID.fromString((String)data.get(Key.get("potion_cauldron_overlay"), PersistentDataType.STRING)));
    }

    public static PotionCauldron getCauldronAt(Location location) {
        for (Marker marker : location.getWorld().getEntitiesByClass(Marker.class)) {
            PersistentDataContainer data = marker.getPersistentDataContainer();
            if (!data.has(Key.get("potion_cauldron"), PersistentDataType.BOOLEAN) || !marker.getLocation().getBlock().equals((Object)location.getBlock())) continue;
            return PotionCauldron.fromMarker(marker);
        }
        return null;
    }

    public boolean move(Location location) {
        this.location = location.getBlock().getLocation();
        Marker marker = (Marker)location.getWorld().getEntity(this.markerId);
        if (marker == null) {
            return false;
        }
        marker.teleport(location.getBlock().getLocation());
        TextDisplay overlay = (TextDisplay)location.getWorld().getEntity(this.overlayId);
        if (overlay == null) {
            return false;
        }
        overlay.teleport(location.getBlock().getLocation().add(this.getOffset(this.level)));
        overlay.setRotation(0.0f, -90.0f);
        return true;
    }

    public Location getLocation() {
        return this.location;
    }

    public int getLevel() {
        return this.level;
    }

    public PotionType getType() {
        return this.type;
    }

    public UUID getMarkerId() {
        return this.markerId;
    }

    private Vector getOffset(int level) {
        return new Vector(0.4, (double)((float)(level * 3 + 6) / 16.0f), 0.99);
    }
}

