/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.chunkloaders;

import me.teakivy.teakstweaks.packs.BasePack;
import me.teakivy.teakstweaks.utils.config.Config;
import me.teakivy.teakstweaks.utils.permission.Permission;
import me.teakivy.teakstweaks.utils.register.TTPack;
import net.kyori.adventure.text.ComponentLike;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.Marker;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ChunkLoaders
extends BasePack {
    public ChunkLoaders() {
        super(TTPack.CHUNK_LOADERS, Material.LODESTONE);
    }

    @EventHandler
    public void onItemDrop(final PlayerDropItemEvent event) {
        if (!Permission.CHUNK_LOADERS.check((CommandSender)event.getPlayer())) {
            return;
        }
        final Item item = event.getItemDrop();
        if (!item.getItemStack().getType().toString().equalsIgnoreCase(this.getConfig().getString("cost"))) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                Block block = item.getLocation().add(0.0, -0.5, 0.0).getBlock();
                if (block.getType() != Material.LODESTONE) {
                    return;
                }
                if (block.getChunk().isForceLoaded()) {
                    this.cancel();
                    event.getPlayer().sendMessage(ChunkLoaders.this.getText("already_loaded", new ComponentLike[0]));
                    return;
                }
                if (event.getItemDrop().isDead() || event.getItemDrop().getItemStack().getAmount() < 1) {
                    this.cancel();
                    return;
                }
                block.getLocation().getChunk().setForceLoaded(true);
                Marker marker = (Marker)block.getWorld().spawnEntity(block.getLocation().add(0.5, 1.0, 0.5), EntityType.MARKER);
                marker.addScoreboardTag("loaded");
                if (Config.getBoolean("packs.chunk-loaders.show-particles")) {
                    marker.getWorld().spawnParticle(Particle.FLAME, item.getLocation(), 100, 0.0, 0.0, 0.0, 0.5);
                }
                ItemStack newItem = item.getItemStack().clone();
                newItem.setAmount(newItem.getAmount() - 1);
                item.setItemStack(newItem);
                event.getPlayer().sendMessage(ChunkLoaders.this.getText("loaded", new ComponentLike[0]));
                if (event.getItemDrop().isDead() || event.getItemDrop().getItemStack().getAmount() < 1) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.getPlugin(), 1L, 20L);
    }

    @EventHandler
    public void onBreak(BlockBreakEvent event) {
        if (event.getBlock().getType() != Material.LODESTONE) {
            return;
        }
        Block block = event.getBlock();
        for (Entity nearbyEntity : block.getWorld().getNearbyEntities(block.getLocation().add(0.5, 1.0, 0.5), 0.1, 0.1, 0.1)) {
            if (!nearbyEntity.getScoreboardTags().contains("loaded") || nearbyEntity.getType() != EntityType.MARKER) continue;
            block.getLocation().getChunk().setForceLoaded(false);
            nearbyEntity.remove();
            return;
        }
    }
}

