/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.classicfishingloot;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class FishingLootTable {
    static HashMap<Enchantment, Integer> enchants = new HashMap();

    public static void register() {
        if (enchants.isEmpty()) {
            FishingLootTable.addEnchant(Enchantment.MENDING, 1);
            FishingLootTable.addEnchant(Enchantment.UNBREAKING, 3);
            FishingLootTable.addEnchant(Enchantment.VANISHING_CURSE, 1);
            FishingLootTable.addEnchant(Enchantment.AQUA_AFFINITY, 1);
            FishingLootTable.addEnchant(Enchantment.BLAST_PROTECTION, 4);
            FishingLootTable.addEnchant(Enchantment.BINDING_CURSE, 1);
            FishingLootTable.addEnchant(Enchantment.DEPTH_STRIDER, 3);
            FishingLootTable.addEnchant(Enchantment.FEATHER_FALLING, 4);
            FishingLootTable.addEnchant(Enchantment.FIRE_PROTECTION, 4);
            FishingLootTable.addEnchant(Enchantment.FROST_WALKER, 2);
            FishingLootTable.addEnchant(Enchantment.PROJECTILE_PROTECTION, 4);
            FishingLootTable.addEnchant(Enchantment.PROTECTION, 4);
            FishingLootTable.addEnchant(Enchantment.RESPIRATION, 3);
            FishingLootTable.addEnchant(Enchantment.SOUL_SPEED, 3);
            FishingLootTable.addEnchant(Enchantment.THORNS, 3);
            FishingLootTable.addEnchant(Enchantment.BANE_OF_ARTHROPODS, 5);
            FishingLootTable.addEnchant(Enchantment.CHANNELING, 1);
            FishingLootTable.addEnchant(Enchantment.EFFICIENCY, 5);
            FishingLootTable.addEnchant(Enchantment.FIRE_ASPECT, 1);
            FishingLootTable.addEnchant(Enchantment.LOOTING, 3);
            FishingLootTable.addEnchant(Enchantment.KNOCKBACK, 2);
            FishingLootTable.addEnchant(Enchantment.SHARPNESS, 5);
            FishingLootTable.addEnchant(Enchantment.SMITE, 5);
            FishingLootTable.addEnchant(Enchantment.SWEEPING_EDGE, 3);
            FishingLootTable.addEnchant(Enchantment.FLAME, 1);
            FishingLootTable.addEnchant(Enchantment.IMPALING, 5);
            FishingLootTable.addEnchant(Enchantment.INFINITY, 1);
            FishingLootTable.addEnchant(Enchantment.LOYALTY, 3);
            FishingLootTable.addEnchant(Enchantment.RIPTIDE, 3);
            FishingLootTable.addEnchant(Enchantment.MULTISHOT, 1);
            FishingLootTable.addEnchant(Enchantment.PIERCING, 4);
            FishingLootTable.addEnchant(Enchantment.POWER, 5);
            FishingLootTable.addEnchant(Enchantment.PUNCH, 2);
            FishingLootTable.addEnchant(Enchantment.QUICK_CHARGE, 3);
            FishingLootTable.addEnchant(Enchantment.FORTUNE, 3);
            FishingLootTable.addEnchant(Enchantment.LURE, 3);
            FishingLootTable.addEnchant(Enchantment.LUCK_OF_THE_SEA, 3);
            FishingLootTable.addEnchant(Enchantment.SILK_TOUCH, 1);
        }
    }

    private static void addEnchant(Enchantment enchantment, Integer maxLevel) {
        enchants.put(enchantment, maxLevel);
    }

    public static ItemStack generateFishingLoot(int los, boolean inJungle) {
        Random rand = new Random();
        double lootType = (rand.nextInt(10000) + 1) / 100;
        if (!inJungle) {
            if (los == 0) {
                if (lootType <= 85.0) {
                    return FishingLootTable.generateFishLoot(60.0, 25.0, 2.0, 13.0);
                }
                if (lootType <= 90.0) {
                    return FishingLootTable.generateTreasureLoot(16.7, 16.7, 16.7, 16.7, 16.7, 16.7);
                }
                return FishingLootTable.generateJunkLoot(17.0, 10.0, 2.0, 10.0, 10.0, 10.0, 5.0, 5.0, 10.0, 10.0, 1.0, 10.0);
            }
            if (los == 1) {
                if (lootType <= 84.8) {
                    return FishingLootTable.generateFishLoot(60.1, 25.0, 2.0, 12.9);
                }
                if (lootType <= 91.89999999999999) {
                    return FishingLootTable.generateTreasureLoot(16.7, 16.7, 16.7, 16.7, 16.7, 16.7);
                }
                return FishingLootTable.generateJunkLoot(17.0, 10.0, 2.0, 10.0, 10.0, 10.0, 5.0, 5.0, 10.0, 10.0, 1.0, 10.0);
            }
            if (los == 2) {
                if (lootType <= 84.8) {
                    return FishingLootTable.generateFishLoot(59.9, 25.02, 2.007, 13.0);
                }
                if (lootType <= 94.0) {
                    return FishingLootTable.generateTreasureLoot(16.7, 16.7, 16.7, 16.7, 16.7, 16.7);
                }
                return FishingLootTable.generateJunkLoot(17.0, 10.0, 2.0, 10.0, 10.0, 10.0, 5.0, 5.0, 10.0, 10.0, 1.0, 10.0);
            }
            if (los == 3) {
                if (lootType <= 84.5) {
                    return FishingLootTable.generateFishLoot(60.0, 25.0, 2.0, 13.0);
                }
                if (lootType <= 95.8) {
                    return FishingLootTable.generateTreasureLoot(16.7, 16.7, 16.7, 16.7, 16.7, 16.7);
                }
                return FishingLootTable.generateJunkLoot(17.0, 10.0, 2.0, 10.0, 10.0, 10.0, 5.0, 5.0, 10.0, 10.0, 1.0, 10.0);
            }
            if (los > 3 && los < 10) {
                if (lootType <= 60.0) {
                    return FishingLootTable.generateFishLoot(60.0, 25.0, 2.0, 13.0);
                }
                if (lootType <= 98.0) {
                    return FishingLootTable.generateTreasureLoot(16.7, 16.7, 16.7, 16.7, 16.7, 16.7);
                }
                return FishingLootTable.generateJunkLoot(17.0, 10.0, 2.0, 10.0, 10.0, 10.0, 5.0, 5.0, 10.0, 10.0, 1.0, 10.0);
            }
            if (los >= 10) {
                return FishingLootTable.generateTreasureLoot(16.7, 16.7, 16.7, 16.7, 16.7, 16.7);
            }
        }
        return new ItemStack(Material.COD);
    }

    private static ItemStack generateFishLoot(double cod, double salmon, double tropical, double pufferfish) {
        Random rand = new Random();
        int fish = rand.nextInt(100) + 1;
        if ((double)fish <= cod) {
            return new ItemStack(Material.COD);
        }
        if ((double)fish <= cod + salmon) {
            return new ItemStack(Material.SALMON);
        }
        if ((double)fish <= cod + salmon + tropical) {
            return new ItemStack(Material.TROPICAL_FISH);
        }
        return new ItemStack(Material.PUFFERFISH);
    }

    private static ItemStack generateTreasureLoot(double bow, double enchantedBook, double fishingRod, double nameTag, double nautilusShell, double saddle) {
        Random rand = new Random();
        int fish = rand.nextInt(100) + 1;
        if ((double)fish <= bow) {
            return FishingLootTable.getTreasureBow();
        }
        if ((double)fish <= bow + enchantedBook) {
            return FishingLootTable.getTreasureBook();
        }
        if ((double)fish <= bow + enchantedBook + fishingRod) {
            return FishingLootTable.getTreasureFishingRod();
        }
        if ((double)fish <= bow + enchantedBook + fishingRod + nameTag) {
            return new ItemStack(Material.NAME_TAG);
        }
        if ((double)fish <= bow + enchantedBook + fishingRod + nameTag + nautilusShell) {
            return new ItemStack(Material.NAUTILUS_SHELL);
        }
        return new ItemStack(Material.SADDLE);
    }

    private static ItemStack generateJunkLoot(double lilyPad, double bowl, double fishingRod, double leather, double leatherBoots, double rottenFlesh, double stick, double string, double waterBottls, double bone, double inkSac, double tripwireHook) {
        Random rand = new Random();
        int fish = rand.nextInt(100) + 1;
        if ((double)fish <= lilyPad) {
            return new ItemStack(Material.LILY_PAD);
        }
        if ((double)fish <= lilyPad + bowl) {
            return new ItemStack(Material.BOWL);
        }
        if ((double)fish <= lilyPad + bowl + fishingRod) {
            return FishingLootTable.getJunkFishingRod();
        }
        if ((double)fish <= lilyPad + bowl + fishingRod + leather) {
            return new ItemStack(Material.LEATHER);
        }
        if ((double)fish <= lilyPad + bowl + fishingRod + leather + leatherBoots) {
            return FishingLootTable.getJunkBoots();
        }
        if ((double)fish <= lilyPad + bowl + fishingRod + leather + leatherBoots + rottenFlesh) {
            return new ItemStack(Material.ROTTEN_FLESH);
        }
        if ((double)fish <= lilyPad + bowl + fishingRod + leather + leatherBoots + rottenFlesh + stick) {
            return new ItemStack(Material.STICK);
        }
        if ((double)fish <= lilyPad + bowl + fishingRod + leather + leatherBoots + rottenFlesh + stick + string) {
            return new ItemStack(Material.STRING);
        }
        if ((double)fish <= lilyPad + bowl + fishingRod + leather + leatherBoots + rottenFlesh + stick + waterBottls + bone) {
            return new ItemStack(Material.BONE);
        }
        if ((double)fish <= lilyPad + bowl + fishingRod + leather + leatherBoots + rottenFlesh + stick + waterBottls + bone + inkSac) {
            return new ItemStack(Material.INK_SAC);
        }
        return new ItemStack(Material.TRIPWIRE_HOOK);
    }

    public static ItemStack getJunkFishingRod() {
        ItemStack item = new ItemStack(Material.FISHING_ROD);
        item.setDurability((short)(new Random().nextInt(item.getType().getMaxDurability()) + 1));
        return item;
    }

    public static ItemStack getJunkBoots() {
        ItemStack item = new ItemStack(Material.LEATHER_BOOTS);
        item.setDurability((short)(new Random().nextInt(item.getType().getMaxDurability()) + 1));
        return item;
    }

    public static ItemStack getTreasureBow() {
        ItemStack item = new ItemStack(Material.BOW);
        HashMap<Enchantment, Integer> possibleEnchants = new HashMap<Enchantment, Integer>();
        possibleEnchants.put(Enchantment.FLAME, 1);
        possibleEnchants.put(Enchantment.INFINITY, 1);
        possibleEnchants.put(Enchantment.MENDING, 1);
        possibleEnchants.put(Enchantment.POWER, 5);
        possibleEnchants.put(Enchantment.PUNCH, 2);
        possibleEnchants.put(Enchantment.UNBREAKING, 3);
        Random rand = new Random();
        ArrayList enchantments = new ArrayList();
        possibleEnchants.forEach((enchant, max) -> enchantments.add(enchant));
        for (int i = 0; i < possibleEnchants.size(); ++i) {
            if (rand.nextInt(4) != 2 || enchantments.get(i) == Enchantment.MENDING && item.getEnchantments().containsKey(Enchantment.INFINITY)) continue;
            item.addUnsafeEnchantment((Enchantment)enchantments.get(i), rand.nextInt((Integer)possibleEnchants.get(enchantments.get(i))) + 1);
        }
        item.setDurability((short)(rand.nextInt(item.getType().getMaxDurability()) + 1));
        return item;
    }

    public static ItemStack getTreasureFishingRod() {
        ItemStack item = new ItemStack(Material.FISHING_ROD);
        HashMap<Enchantment, Integer> possibleEnchants = new HashMap<Enchantment, Integer>();
        possibleEnchants.put(Enchantment.LUCK_OF_THE_SEA, 3);
        possibleEnchants.put(Enchantment.LURE, 3);
        possibleEnchants.put(Enchantment.MENDING, 1);
        possibleEnchants.put(Enchantment.UNBREAKING, 3);
        Random rand = new Random();
        ArrayList enchantments = new ArrayList();
        possibleEnchants.forEach((enchant, max) -> enchantments.add(enchant));
        for (int i = 0; i < possibleEnchants.size(); ++i) {
            if (rand.nextInt(4) != 2) continue;
            item.addUnsafeEnchantment((Enchantment)enchantments.get(i), rand.nextInt((Integer)possibleEnchants.get(enchantments.get(i))) + 1);
        }
        item.setDurability((short)(rand.nextInt(item.getType().getMaxDurability()) + 1));
        return item;
    }

    public static ItemStack getTreasureBook() {
        FishingLootTable.register();
        ItemStack item = new ItemStack(Material.ENCHANTED_BOOK);
        EnchantmentStorageMeta meta = (EnchantmentStorageMeta)item.getItemMeta();
        Random rand = new Random();
        ArrayList enchantments = new ArrayList();
        enchants.forEach((enchant, max) -> enchantments.add(enchant));
        for (int i = 0; i < enchants.size(); ++i) {
            int tonextlevel = 17;
            if (item.getEnchantments().size() >= 3) {
                tonextlevel = 35;
            }
            if (item.getEnchantments().size() >= 4) {
                tonextlevel = 43;
            }
            if (item.getEnchantments().size() >= 5) {
                tonextlevel = 50;
            }
            if (item.getEnchantments().size() >= 7) {
                tonextlevel = 100;
            }
            if (rand.nextInt(tonextlevel) != 2) continue;
            meta.addStoredEnchant((Enchantment)enchantments.get(i), rand.nextInt(enchants.get(enchantments.get(i))) + 1, true);
        }
        if (meta.getEnchants().isEmpty()) {
            meta.addStoredEnchant(Enchantment.EFFICIENCY, rand.nextInt(Enchantment.EFFICIENCY.getMaxLevel()) + 1, true);
        }
        item.setItemMeta((ItemMeta)meta);
        return item;
    }
}

