/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.collectibleblocks;

import java.util.HashSet;
import me.teakivy.teakstweaks.TeaksTweaks;
import me.teakivy.teakstweaks.packs.BasePack;
import me.teakivy.teakstweaks.utils.register.TTPack;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class CollectibleBlocks
extends BasePack {
    private final HashSet<Material> alwaysDropBlocks;
    private final HashSet<Material> silkTouchBlocks;
    private final boolean includeAlwaysDropBlocks = this.getConfig().getBoolean("always-drop.enabled");
    private final boolean includeSilkTouchBlocks;

    public CollectibleBlocks() {
        super(TTPack.COLLECTIBLE_BLOCKS, Material.ENDER_CHEST);
        Material item;
        this.alwaysDropBlocks = new HashSet();
        if (this.includeAlwaysDropBlocks) {
            for (String block : this.getConfig().getStringList("always-drop.blocks")) {
                item = Material.matchMaterial((String)block);
                if (item == null || !item.isBlock()) continue;
                this.alwaysDropBlocks.add(item);
            }
        }
        this.includeSilkTouchBlocks = this.getConfig().getBoolean("silk-touch-drop.enabled");
        this.silkTouchBlocks = new HashSet();
        if (this.includeSilkTouchBlocks) {
            for (String block : this.getConfig().getStringList("silk-touch-drop.blocks")) {
                item = Material.matchMaterial((String)block);
                if (item == null || !item.isBlock()) continue;
                this.silkTouchBlocks.add(item);
            }
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getPlayer().getGameMode() == GameMode.CREATIVE) {
            return;
        }
        Material blockType = event.getBlock().getType();
        if (this.includeAlwaysDropBlocks && this.alwaysDropBlocks.contains(event.getBlock().getType())) {
            event.setCancelled(true);
            event.getBlock().setType(Material.AIR);
            Bukkit.getScheduler().runTaskLater((Plugin)TeaksTweaks.getInstance(), () -> event.getBlock().getWorld().dropItemNaturally(event.getBlock().getLocation().add(0.5, 0.5, 0.5), new ItemStack(blockType)), 1L);
            return;
        }
        ItemStack handItem = event.getPlayer().getInventory().getItemInMainHand();
        if (this.includeSilkTouchBlocks && this.silkTouchBlocks.contains(event.getBlock().getType()) && handItem.containsEnchantment(Enchantment.SILK_TOUCH)) {
            event.setCancelled(true);
            event.getBlock().setType(Material.AIR);
            Bukkit.getScheduler().runTaskLater((Plugin)TeaksTweaks.getInstance(), () -> event.getBlock().getWorld().dropItemNaturally(event.getBlock().getLocation().add(0.5, 0.5, 0.5), new ItemStack(blockType)), 1L);
        }
    }
}

