/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.coordshud;

import me.teakivy.teakstweaks.TeaksTweaks;
import me.teakivy.teakstweaks.utils.config.Config;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CoordsHudDisplay {
    private static World world;
    static String hudMessage;

    public static void init() {
        hudMessage = Config.getPackConfig("coords-hud").getString("hud-message");
        world = Bukkit.getWorld((String)Config.getString("packs.coords-hud.time-world"));
        if (world == null) {
            world = (World)Bukkit.getWorlds().get(0);
        }
    }

    public static void showHud(Player player) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)TeaksTweaks.getInstance(), () -> {
            Location loc = player.getLocation().getBlock().getLocation();
            if (Config.getBoolean("packs.coords-hud.use-player-position")) {
                loc = player.getLocation();
            }
            Location playerLocation = player.getLocation();
            float playerDirection = playerLocation.getYaw();
            String directionAbbr = CoordsHudDisplay.getDirectionAbbr(playerDirection);
            String worldTime = CoordsHudDisplay.getWorldTime();
            player.sendActionBar(MiniMessage.miniMessage().deserialize(hudMessage, new TagResolver[]{Placeholder.parsed((String)"x", (String)("" + loc.getBlockX())), Placeholder.parsed((String)"y", (String)("" + loc.getBlockY())), Placeholder.parsed((String)"z", (String)("" + loc.getBlockZ())), Placeholder.parsed((String)"direction", (String)directionAbbr), Placeholder.parsed((String)"world_time", (String)worldTime)}));
        });
    }

    public static String getDirectionAbbr(float direction) {
        if (direction >= 135.0f || direction <= -135.0f) {
            return "N";
        }
        if (direction >= -135.0f && direction <= -45.0f) {
            return "E";
        }
        if (direction >= -45.0f && direction <= 45.0f) {
            return "S";
        }
        if (direction >= 45.0f && direction <= 135.0f) {
            return "W";
        }
        return "X";
    }

    public static String getWorldTime() {
        long ticks = world.getTime();
        int hours = (int)((ticks / 1000L + 6L) % 24L);
        int minutes = (int)((double)(ticks % 1000L / 10L) * 0.6);
        return String.format("%02d:%02d", hours, minutes);
    }

    public static String getWorld(Player player) {
        return player.getWorld().getName();
    }
}

