/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.durabilityping;

import java.util.HashMap;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import me.teakivy.teakstweaks.packs.BasePack;
import me.teakivy.teakstweaks.utils.config.Config;
import me.teakivy.teakstweaks.utils.permission.Permission;
import me.teakivy.teakstweaks.utils.register.TTPack;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.title.TitlePart;
import org.apache.commons.lang3.text.WordUtils;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;

public class DurabilityPing
extends BasePack {
    private final HashMap<UUID, Long> pingCooldown = new HashMap();

    public DurabilityPing() {
        super(TTPack.DURABILITY_PING, Material.DIAMOND_PICKAXE);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (player.getScoreboardTags().contains("dp_customized")) {
            return;
        }
        if (this.getConfig().getBoolean("default-settings.ping-for-hand-items")) {
            player.addScoreboardTag("dp_ping_for_hand_items");
        } else {
            player.removeScoreboardTag("dp_ping_for_hand_items");
        }
        if (this.getConfig().getBoolean("default-settings.ping-for-armor-items")) {
            player.addScoreboardTag("dp_ping_for_armor_items");
        } else {
            player.removeScoreboardTag("dp_ping_for_armor_items");
        }
        if (this.getConfig().getBoolean("default-settings.ping-with-sound")) {
            player.addScoreboardTag("dp_ping_with_sound");
        } else {
            player.removeScoreboardTag("dp_ping_with_sound");
        }
        if (player.getScoreboardTags().contains("dp_display_hidden") || player.getScoreboardTags().contains("dp_display_subtitle") || player.getScoreboardTags().contains("dp_display_title") || player.getScoreboardTags().contains("dp_display_chat") || player.getScoreboardTags().contains("dp_display_actionbar")) {
            return;
        }
        if (Objects.requireNonNull(this.getConfig().getString("default-settings.display")).equalsIgnoreCase("hidden")) {
            player.addScoreboardTag("dp_display_hidden");
        }
        if (Objects.requireNonNull(this.getConfig().getString("default-settings.display")).equalsIgnoreCase("subtitle")) {
            player.addScoreboardTag("dp_display_subtitle");
        }
        if (Objects.requireNonNull(this.getConfig().getString("default-settings.display")).equalsIgnoreCase("title")) {
            player.addScoreboardTag("dp_display_title");
        }
        if (Objects.requireNonNull(this.getConfig().getString("default-settings.display")).equalsIgnoreCase("chat")) {
            player.addScoreboardTag("dp_display_chat");
        }
        if (Objects.requireNonNull(this.getConfig().getString("default-settings.display")).equalsIgnoreCase("actionbar")) {
            player.addScoreboardTag("dp_display_actionbar");
        }
    }

    @EventHandler
    public void onItemUse(PlayerItemDamageEvent event) {
        if (!Permission.DURABILITY_PING.check((CommandSender)event.getPlayer())) {
            return;
        }
        ItemStack item = event.getItem();
        Player player = event.getPlayer();
        float durability = event.getItem().getType().getMaxDurability() - (event.getItem().getDurability() + 1);
        float maxDurability = event.getItem().getType().getMaxDurability();
        int percentDamaged = (int)(durability / maxDurability * 100.0f);
        if (this.getConfig().getInt("ping-at-percent") >= percentDamaged) {
            if (this.pingCooldown.containsKey(player.getUniqueId()) && this.pingCooldown.get(player.getUniqueId()) > System.currentTimeMillis()) {
                return;
            }
            if (player.getScoreboardTags().contains("dp_ping_for_hand_items") && player.getScoreboardTags().contains("dp_ping_for_armor_items")) {
                DurabilityPing.pingPlayer(player, item, durability);
            } else if (this.isArmor(item)) {
                if (player.getScoreboardTags().contains("dp_ping_for_armor_items")) {
                    DurabilityPing.pingPlayer(player, item, durability);
                }
            } else if (player.getScoreboardTags().contains("dp_ping_for_hand_items")) {
                DurabilityPing.pingPlayer(player, item, durability);
            }
            this.pingCooldown.put(player.getUniqueId(), System.currentTimeMillis() + (long)Config.getInt("packs.durability-ping.ping-cooldown") * 1000L);
        }
    }

    public static void pingPlayer(Player player, ItemStack item, float durability, String style, boolean playSound) {
        float maxDurability = item.getType().getMaxDurability();
        if (durability == 0.0f) {
            return;
        }
        if (DurabilityPing.getSetting(player, "ping_with_sound").equalsIgnoreCase("true") && playSound) {
            player.playSound(player.getLocation(), Sound.BLOCK_ANVIL_LAND, 1.0f, 2.0f);
        }
        if (style.equalsIgnoreCase("hidden")) {
            return;
        }
        if (style.equalsIgnoreCase("subtitle")) {
            player.sendTitlePart(TitlePart.TITLE, (Object)DurabilityPing.getDurabilityMessage("ping.subtitle.title", item, durability, maxDurability));
            player.sendTitlePart(TitlePart.SUBTITLE, (Object)DurabilityPing.getDurabilityMessage("ping.subtitle.subtitle", item, durability, maxDurability));
        }
        if (style.equalsIgnoreCase("title")) {
            player.sendTitlePart(TitlePart.TITLE, (Object)DurabilityPing.getDurabilityMessage("ping.title.title", item, durability, maxDurability));
            player.sendTitlePart(TitlePart.SUBTITLE, (Object)DurabilityPing.getDurabilityMessage("ping.title.subtitle", item, durability, maxDurability));
        }
        if (style.equalsIgnoreCase("chat")) {
            player.sendMessage(DurabilityPing.getDurabilityMessage("ping.chat.message", item, durability, maxDurability));
        }
        if (style.equalsIgnoreCase("actionbar")) {
            player.sendActionBar(DurabilityPing.getDurabilityMessage("ping.actionbar.message", item, durability, maxDurability));
        }
    }

    private static Component getDurabilityMessage(String path, ItemStack item, float durability, float maxDurability) {
        return Component.translatable((String)("durability_ping." + path), (ComponentLike[])new ComponentLike[]{DurabilityPing.insert("item_type", DurabilityPing.getItemName(item)), DurabilityPing.insert("item_durability", (int)Math.ceil(durability)), DurabilityPing.insert("item_max_durability", (int)maxDurability)});
    }

    public static void pingPlayer(Player player, ItemStack item, float durability) {
        DurabilityPing.pingPlayer(player, item, durability, DurabilityPing.getSetting(player, "display"), true);
    }

    private boolean isArmor(ItemStack item) {
        return switch (item.getType()) {
            case Material.LEATHER_HELMET, Material.LEATHER_CHESTPLATE, Material.LEATHER_LEGGINGS, Material.LEATHER_BOOTS, Material.CHAINMAIL_HELMET, Material.CHAINMAIL_CHESTPLATE, Material.CHAINMAIL_LEGGINGS, Material.CHAINMAIL_BOOTS, Material.IRON_HELMET, Material.IRON_CHESTPLATE, Material.IRON_LEGGINGS, Material.IRON_BOOTS, Material.GOLDEN_HELMET, Material.GOLDEN_CHESTPLATE, Material.GOLDEN_LEGGINGS, Material.GOLDEN_BOOTS, Material.DIAMOND_HELMET, Material.DIAMOND_CHESTPLATE, Material.DIAMOND_LEGGINGS, Material.DIAMOND_BOOTS, Material.NETHERITE_HELMET, Material.NETHERITE_CHESTPLATE, Material.NETHERITE_LEGGINGS, Material.NETHERITE_BOOTS, Material.ELYTRA, Material.TURTLE_HELMET, Material.COPPER_HELMET, Material.COPPER_CHESTPLATE, Material.COPPER_LEGGINGS, Material.COPPER_BOOTS -> true;
            default -> false;
        };
    }

    public static String getSetting(Player player, String setting) {
        if (setting.equalsIgnoreCase("customized")) {
            if (player.getScoreboardTags().contains("dp_customized")) {
                return "true";
            }
            if (!player.getScoreboardTags().contains("dp_customized")) {
                return "false";
            }
        }
        if (setting.equalsIgnoreCase("ping_for_hand_items")) {
            if (player.getScoreboardTags().contains("dp_ping_for_hand_items")) {
                return "true";
            }
            if (!player.getScoreboardTags().contains("dp_ping_for_hand_items")) {
                return "false";
            }
        }
        if (setting.equalsIgnoreCase("ping_for_armor_items")) {
            if (player.getScoreboardTags().contains("dp_ping_for_armor_items")) {
                return "true";
            }
            if (!player.getScoreboardTags().contains("dp_ping_for_armor_items")) {
                return "false";
            }
        }
        if (setting.equalsIgnoreCase("ping_with_sound")) {
            if (player.getScoreboardTags().contains("dp_ping_with_sound")) {
                return "true";
            }
            if (!player.getScoreboardTags().contains("dp_ping_with_sound")) {
                return "false";
            }
        }
        if (setting.equalsIgnoreCase("display")) {
            if (player.getScoreboardTags().contains("dp_display_subtitle")) {
                return "subtitle";
            }
            if (player.getScoreboardTags().contains("dp_display_title")) {
                return "title";
            }
            if (player.getScoreboardTags().contains("dp_display_chat")) {
                return "chat";
            }
            if (player.getScoreboardTags().contains("dp_display_actionbar")) {
                return "actionbar";
            }
            return "hidden";
        }
        return null;
    }

    public static String getItemName(ItemStack itemStack) {
        return WordUtils.capitalize((String)itemStack.getType().toString().replace("_", " ").toLowerCase(Locale.ROOT));
    }
}

